/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleResultSet;

class OracleDatabaseMetaData
extends oracle.jdbc.OracleDatabaseMetaData {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Aug_26_08:17:01_PDT_2011";
    public static final boolean TRACE = false;

    public OracleDatabaseMetaData(oracle.jdbc.internal.OracleConnection oracleConnection) {
        super(oracleConnection);
    }

    public OracleDatabaseMetaData(OracleConnection oracleConnection) {
        this((oracle.jdbc.internal.OracleConnection)oracleConnection);
    }

    public synchronized ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        boolean bl = this.connection.getIncludeSynonyms();
        if (bl && string2 != null && !this.hasSqlWildcard(string2) && string3 != null && !this.hasSqlWildcard(string3)) {
            return this.getColumnsNoWildcards(this.stripSqlEscapes(string2), this.stripSqlEscapes(string3), string4);
        }
        return this.getColumnsWithWildcards(string2, string3, string4, bl);
    }

    ResultSet getColumnsNoWildcards(String string, String string2, String string3) throws SQLException {
        String string4 = this.getColumnsNoWildcardsPlsql();
        CallableStatement callableStatement = this.connection.prepareCall(string4);
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3 == null ? "%" : string3);
        callableStatement.registerOutParameter(4, -10);
        callableStatement.execute();
        ResultSet resultSet = ((OracleCallableStatement)callableStatement).getCursor(4);
        ((OracleResultSet)resultSet).closeStatementOnClose();
        return resultSet;
    }

    ResultSet getColumnsWithWildcards(String string, String string2, String string3, boolean bl) throws SQLException {
        short s2 = this.connection.getVersionNumber();
        String string4 = "SELECT ";
        String string5 = " NULL AS table_cat,\n";
        String string6 = "";
        if (s2 >= 10200 & s2 < 11100 & bl) {
            string6 = "/*+ CHOOSE */";
        }
        String string7 = "       t.owner AS table_schem,\n       t.table_name AS table_name,\n";
        String string8 = "       DECODE(s.owner, NULL, t.owner, s.owner)\n              AS table_schem,\n       DECODE(s.synonym_name, NULL, t.table_name, s.synonym_name)\n              AS table_name,\n";
        String string9 = "         DECODE (t.data_type, 'CHAR', t.char_length,                   'VARCHAR', t.char_length,                   'VARCHAR2', t.char_length,                   'NVARCHAR2', t.char_length,                   'NCHAR', t.char_length,                   'NUMBER', 0,           t.data_length),";
        String string10 = "       t.column_name AS column_name,\n       DECODE (t.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n               'LONG', -1, 'DATE', " + (((PhysicalConnection)this.connection).mapDateToTimestamp ? "93" : "91") + ", 'RAW', -3, 'LONG RAW', -4,  \n" + "               'BLOB', 2004, 'CLOB', 2005, 'BFILE', -13, 'FLOAT', 6, \n" + "               'TIMESTAMP(6)', 93, 'TIMESTAMP(6) WITH TIME ZONE', -101, \n" + "               'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, \n" + "               'INTERVAL YEAR(2) TO MONTH', -103, \n" + "               'INTERVAL DAY(2) TO SECOND(6)', -104, \n" + "               'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101, \n" + "               'XMLTYPE', 2009, \n" + "               1111)\n" + "              AS data_type,\n" + "       t.data_type AS type_name,\n" + "       DECODE (t.data_precision, null, " + (s2 > 9000 ? string9 : "t.data_length,") + "         t.data_precision)\n" + "              AS column_size,\n" + "       0 AS buffer_length,\n" + "       DECODE (t.data_type, " + "               'NUMBER', DECODE (t.data_precision, " + "                                 null, -127, " + "                                 t.data_scale), " + "               t.data_scale) AS decimal_digits,\n" + "       10 AS num_prec_radix,\n" + "       DECODE (t.nullable, 'N', 0, 1) AS nullable,\n";
        String string11 = "       c.comments AS remarks,\n";
        String string12 = "       NULL AS remarks,\n";
        String string13 = "       t.data_default AS column_def,\n       0 AS sql_data_type,\n       0 AS sql_datetime_sub,\n       t.data_length AS char_octet_length,\n       t.column_id AS ordinal_position,\n       DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable\n";
        String string14 = "FROM all_tab_columns t";
        String string15 = ", all_synonyms s";
        String string16 = ", all_col_comments c";
        String string17 = "WHERE t.owner LIKE :1 ESCAPE '/'\n  AND t.table_name LIKE :2 ESCAPE '/'\n  AND t.column_name LIKE :3 ESCAPE '/'\n";
        String string18 = "WHERE (t.owner LIKE :4 ESCAPE '/' OR\n       (s.owner LIKE :5 ESCAPE '/' AND t.owner = s.table_owner))\n  AND (t.table_name LIKE :6 ESCAPE '/' OR\n       s.synonym_name LIKE :7 ESCAPE '/')\n  AND t.column_name LIKE :8 ESCAPE '/'\n";
        String string19 = "  AND t.owner = c.owner (+)\n  AND t.table_name = c.table_name (+)\n  AND t.column_name = c.column_name (+)\n";
        String string20 = "  AND s.table_name (+) = t.table_name\n  AND ((DECODE(s.owner, t.owner, 'OK',\n                       'PUBLIC', 'OK',\n                       NULL, 'OK',\n                       'NOT OK') = 'OK') OR\n       (t.owner LIKE :9 AND t.owner = s.table_owner) OR\n       (s.owner LIKE :10 AND t.owner = s.table_owner))";
        String string21 = "ORDER BY table_schem, table_name, ordinal_position\n";
        String string22 = string4 + string6 + string5;
        string22 = bl ? string22 + string8 : string22 + string7;
        string22 = string22 + string10;
        string22 = this.connection.getRemarksReporting() ? string22 + string11 : string22 + string12;
        string22 = string22 + string13 + string14;
        if (this.connection.getRemarksReporting()) {
            string22 = string22 + string16;
        }
        if (bl) {
            string22 = string22 + string15;
        }
        string22 = bl ? string22 + "\n" + string18 : string22 + "\n" + string17;
        if (this.connection.getRemarksReporting()) {
            string22 = string22 + string19;
        }
        if (this.connection.getIncludeSynonyms()) {
            string22 = string22 + string20;
        }
        string22 = string22 + "\n" + string21;
        PreparedStatement preparedStatement = this.connection.prepareStatement(string22);
        if (bl) {
            preparedStatement.setString(1, string == null ? "%" : string);
            preparedStatement.setString(2, string == null ? "%" : string);
            preparedStatement.setString(3, string2 == null ? "%" : string2);
            preparedStatement.setString(4, string2 == null ? "%" : string2);
            preparedStatement.setString(5, string3 == null ? "%" : string3);
            preparedStatement.setString(6, string == null ? "%" : string);
            preparedStatement.setString(7, string == null ? "%" : string);
        } else {
            preparedStatement.setString(1, string == null ? "%" : string);
            preparedStatement.setString(2, string2 == null ? "%" : string2);
            preparedStatement.setString(3, string3 == null ? "%" : string3);
        }
        OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public ResultSet getTypeInfo() throws SQLException {
        Statement statement = this.connection.createStatement();
        short s2 = this.connection.getVersionNumber();
        String string = "union select\n 'CHAR' as type_name, 1 as data_type, " + (s2 >= 8100 ? 2000 : 255) + " as precision,\n" + " '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n" + " 1 as nullable, 1 as case_sensitive, 3 as searchable,\n" + " 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n" + " 'CHAR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n" + " NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n" + "from dual\n";
        String string2 = "union select\n 'VARCHAR2' as type_name, 12 as data_type, " + (s2 >= 8100 ? 4000 : 2000) + " as precision,\n" + " '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n" + " 1 as nullable, 1 as case_sensitive, 3 as searchable,\n" + " 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n" + " 'VARCHAR2' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n" + " NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n" + "from dual\n";
        String string3 = "union select\n 'DATE' as type_name, " + (((PhysicalConnection)this.connection).mapDateToTimestamp ? "93" : "91") + "as data_type, 7 as precision,\n" + " NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n" + " 1 as nullable, 0 as case_sensitive, 3 as searchable,\n" + " 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n" + " 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n" + " NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n" + "from dual\n";
        String string4 = "union select\n 'RAW' as type_name, -3 as data_type, " + (s2 >= 8100 ? 2000 : 255) + " as precision,\n" + " '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n" + " 1 as nullable, 0 as case_sensitive, 3 as searchable,\n" + " 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n" + " 'RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n" + " NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n" + "from dual\n";
        String string5 = "-1";
        String string6 = "union select\n 'BLOB' as type_name, 2004 as data_type, " + string5 + " as precision,\n" + " null as literal_prefix, null as literal_suffix, NULL as create_params,\n" + " 1 as nullable, 0 as case_sensitive, 0 as searchable,\n" + " 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n" + " 'BLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n" + " NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n" + "from dual\n";
        String string7 = "union select\n 'CLOB' as type_name, 2005 as data_type, " + string5 + " as precision,\n" + " '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n" + " 1 as nullable, 1 as case_sensitive, 0 as searchable,\n" + " 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n" + " 'CLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n" + " NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n" + "from dual\n";
        String string8 = "select\n 'NUMBER' as type_name, 2 as data_type, 38 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n 'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + string + string2 + string3 + "union select\n 'DATE' as type_name, 92 as data_type, 7 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'TIMESTAMP' as type_name, 93 as data_type, 11 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'TIMESTAMP WITH TIME ZONE' as type_name, -101 as data_type, 13 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'TIMESTAMP WITH LOCAL TIME ZONE' as type_name, -102 as data_type, 11 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH LOCAL TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'INTERVALYM' as type_name, -103 as data_type, 5 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALYM' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'INTERVALDS' as type_name, -104 as data_type, 4 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALDS' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + string4 + "union select\n 'LONG' as type_name, -1 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'LONG RAW' as type_name, -4 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'NUMBER' as type_name, -7 as data_type, 1 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(1)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'NUMBER' as type_name, -6 as data_type, 3 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(3)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'NUMBER' as type_name, 5 as data_type, 5 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(5)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'NUMBER' as type_name, 4 as data_type, 10 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(10)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'NUMBER' as type_name, -5 as data_type, 38 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'FLOAT' as type_name, 6 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'FLOAT' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'REAL' as type_name, 7 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'REAL' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + (s2 >= 8100 ? string6 + string7 + "union select\n 'REF' as type_name, 2006 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'REF' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'ARRAY' as type_name, 2003 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'ARRAY' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'STRUCT' as type_name, 2002 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'STRUCT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" : "") + "order by data_type\n";
        OracleResultSet oracleResultSet = (OracleResultSet)statement.executeQuery(string8);
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    String getColumnsNoWildcardsPlsql() throws SQLException {
        String string = "declare\n  in_owner varchar2(32) := null;\n  in_name varchar2(32) := null;\n  my_user_name varchar2(32) := null;\n  cnt number := 0;\n  out_owner varchar2(32) := null;\n  out_name  varchar2(32):= null;\n  loc varchar2(32) := null;\n  xxx SYS_REFCURSOR;\nbegin\n  in_owner := ?;\n  in_name := ?;\n  select user into my_user_name from dual;\n  if( my_user_name = in_owner ) then\n    select count(*) into cnt from user_tables where table_name = in_name;\n    if( cnt = 1 ) then\n      out_owner := in_owner;\n      out_name := in_name;\n      loc := 'USER_TABLES';\n    else\n      begin\n        select table_owner, table_name into out_owner, out_name from user_synonyms where synonym_name = in_name;\n      exception\n        when NO_DATA_FOUND then\n        out_owner := null;\n        out_name := null;\n      end;\n      if( not(out_name is null) ) then\n        loc := 'USER_SYNONYMS';\n      end if;\n    end if;\n  else\n    select count(*) into cnt from all_tables where owner = in_owner and table_name = in_name;\n    if( cnt = 1 ) then\n      out_owner := in_owner;\n      out_name := in_name;\n      loc := 'ALL_TABLES';\n    else\n      begin\n        select table_owner, table_name into out_owner, out_name from all_synonyms \n          where  owner = in_owner and synonym_name = in_name;\n      exception\n        when NO_DATA_FOUND then\n          out_owner := null;\n          out_name := null;\n      end;\n      if( not(out_owner is null) ) then\n        loc := 'ALL_SYNONYMS';\n      end if;\n    end if;\n  end if;\n";
        short s2 = this.connection.getVersionNumber();
        String string2 = "open xxx for SELECT NULL AS table_cat,\n";
        String string3 = "       in_owner AS table_schem,\n       in_name AS table_name,\n";
        String string4 = "         DECODE (t.data_type, 'CHAR', t.char_length,                   'VARCHAR', t.char_length,                   'VARCHAR2', t.char_length,                   'NVARCHAR2', t.char_length,                   'NCHAR', t.char_length,                   'NUMBER', 0,           t.data_length),";
        String string5 = "       t.column_name AS column_name,\n       DECODE (t.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n               'LONG', -1, 'DATE', " + (this.connection.getMapDateToTimestamp() ? "93" : "91") + ", 'RAW', -3, 'LONG RAW', -4,  \n" + "               'BLOB', 2004, 'CLOB', 2005, 'BFILE', -13, 'FLOAT', 6, \n" + "               'TIMESTAMP(6)', 93, 'TIMESTAMP(6) WITH TIME ZONE', -101, \n" + "               'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, \n" + "               'INTERVAL YEAR(2) TO MONTH', -103, \n" + "               'INTERVAL DAY(2) TO SECOND(6)', -104, \n" + "               'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101, \n" + "               'XMLTYPE', 2009, \n" + "               1111)\n" + "              AS data_type,\n" + "       t.data_type AS type_name,\n" + "       DECODE (t.data_precision, null, " + (s2 > 9000 ? string4 : "t.data_length,") + "         t.data_precision)\n" + "              AS column_size,\n" + "       0 AS buffer_length,\n" + "       DECODE (t.data_type, " + "               'NUMBER', DECODE (t.data_precision, " + "                                 null, -127, " + "                                 t.data_scale), " + "               t.data_scale) AS decimal_digits,\n" + "       10 AS num_prec_radix,\n" + "       DECODE (t.nullable, 'N', 0, 1) AS nullable,\n";
        String string6 = "       c.comments AS remarks,\n";
        String string7 = "       NULL AS remarks,\n";
        String string8 = "       t.data_default AS column_def,\n       0 AS sql_data_type,\n       0 AS sql_datetime_sub,\n       t.data_length AS char_octet_length,\n       t.column_id AS ordinal_position,\n       DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable\n";
        String string9 = "FROM all_tab_columns t";
        String string10 = ", all_col_comments c";
        String string11 = "WHERE t.owner = out_owner \n  AND t.table_name = out_name\n AND t.column_name LIKE ? ESCAPE '/'\n";
        String string12 = "  AND t.owner = c.owner (+)\n  AND t.table_name = c.table_name (+)\n  AND t.column_name = c.column_name (+)\n";
        String string13 = "ORDER BY table_schem, table_name, ordinal_position\n";
        String string14 = string2;
        string14 = string14 + string3;
        string14 = string14 + string5;
        string14 = this.connection.getRemarksReporting() ? string14 + string6 : string14 + string7;
        string14 = string14 + string8 + string9;
        if (this.connection.getRemarksReporting()) {
            string14 = string14 + string10;
        }
        string14 = string14 + "\n" + string11;
        if (this.connection.getRemarksReporting()) {
            string14 = string14 + string12;
        }
        string14 = string14 + "\n" + string13;
        String string15 = "; \n ? := xxx;\n end;";
        String string16 = string + string14 + string15;
        return string16;
    }
}

