/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter
    protected String goalPrefix;
    @Parameter(defaultValue="false", property="maven.plugin.skip")
    private boolean skip;
    @Parameter
    private List<String> packagingTypes = Collections.singletonList("maven-plugin");
    protected static final String LS = System.lineSeparator();

    protected abstract void generate() throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        if (!this.packagingTypes.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Unsupported packaging type " + this.project.getPackaging() + ", execution skipped"));
            return;
        }
        if (this.skip) {
            this.getLog().warn((CharSequence)"Execution skipped");
            return;
        }
        String defaultGoalPrefix = AbstractGeneratorMojo.getDefaultGoalPrefix(this.project);
        if (this.goalPrefix == null) {
            this.goalPrefix = defaultGoalPrefix;
        } else if (!this.goalPrefix.equals(defaultGoalPrefix)) {
            this.getLog().warn((CharSequence)(LS + LS + "Goal prefix is specified as: '" + this.goalPrefix + "'. Maven currently expects it to be '" + defaultGoalPrefix + "'." + LS));
        }
        this.generate();
    }

    static String getDefaultGoalPrefix(MavenProject project) {
        String defaultGoalPrefix = "maven-plugin-report-plugin".equalsIgnoreCase(project.getArtifactId()) ? "plugin-report" : ("maven-plugin".equalsIgnoreCase(project.getArtifactId()) ? project.getGroupId().substring(project.getGroupId().lastIndexOf(46) + 1) : PluginDescriptor.getGoalPrefixFromArtifactId((String)project.getArtifactId()));
        return defaultGoalPrefix;
    }
}

