/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.MFN_M05_LDPLCHLCC;
import ca.uhn.hl7v2.model.v231.segment.LCH;
import ca.uhn.hl7v2.model.v231.segment.LOC;
import ca.uhn.hl7v2.model.v231.segment.LRL;
import ca.uhn.hl7v2.model.v231.segment.MFE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M05_MFELOCLCHLRLLDPLCHLCC
extends AbstractGroup {
    public MFN_M05_MFELOCLCHLRLLDPLCHLCC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false, false);
            this.add(LOC.class, true, false, false);
            this.add(LCH.class, false, true, false);
            this.add(LRL.class, false, true, false);
            this.add(MFN_M05_LDPLCHLCC.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating MFN_M05_MFELOCLCHLRLLDPLCHLCC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MFE getMFE() {
        MFE retVal = (MFE)this.getTyped("MFE", MFE.class);
        return retVal;
    }

    public LOC getLOC() {
        LOC retVal = (LOC)this.getTyped("LOC", LOC.class);
        return retVal;
    }

    public LCH getLCH() {
        LCH retVal = (LCH)this.getTyped("LCH", LCH.class);
        return retVal;
    }

    public LCH getLCH(int rep) {
        LCH retVal = (LCH)this.getTyped("LCH", rep, LCH.class);
        return retVal;
    }

    public int getLCHReps() {
        return this.getReps("LCH");
    }

    public List<LCH> getLCHAll() throws HL7Exception {
        return this.getAllAsList("LCH", LCH.class);
    }

    public void insertLCH(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition("LCH", (Structure)structure, rep);
    }

    public LCH insertLCH(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH", rep);
    }

    public LCH removeLCH(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH", rep);
    }

    public LRL getLRL() {
        LRL retVal = (LRL)this.getTyped("LRL", LRL.class);
        return retVal;
    }

    public LRL getLRL(int rep) {
        LRL retVal = (LRL)this.getTyped("LRL", rep, LRL.class);
        return retVal;
    }

    public int getLRLReps() {
        return this.getReps("LRL");
    }

    public List<LRL> getLRLAll() throws HL7Exception {
        return this.getAllAsList("LRL", LRL.class);
    }

    public void insertLRL(LRL structure, int rep) throws HL7Exception {
        super.insertRepetition("LRL", (Structure)structure, rep);
    }

    public LRL insertLRL(int rep) throws HL7Exception {
        return (LRL)super.insertRepetition("LRL", rep);
    }

    public LRL removeLRL(int rep) throws HL7Exception {
        return (LRL)super.removeRepetition("LRL", rep);
    }

    public MFN_M05_LDPLCHLCC getLDPLCHLCC() {
        MFN_M05_LDPLCHLCC retVal = (MFN_M05_LDPLCHLCC)this.getTyped("LDPLCHLCC", MFN_M05_LDPLCHLCC.class);
        return retVal;
    }

    public MFN_M05_LDPLCHLCC getLDPLCHLCC(int rep) {
        MFN_M05_LDPLCHLCC retVal = (MFN_M05_LDPLCHLCC)this.getTyped("LDPLCHLCC", rep, MFN_M05_LDPLCHLCC.class);
        return retVal;
    }

    public int getLDPLCHLCCReps() {
        return this.getReps("LDPLCHLCC");
    }

    public List<MFN_M05_LDPLCHLCC> getLDPLCHLCCAll() throws HL7Exception {
        return this.getAllAsList("LDPLCHLCC", MFN_M05_LDPLCHLCC.class);
    }

    public void insertLDPLCHLCC(MFN_M05_LDPLCHLCC structure, int rep) throws HL7Exception {
        super.insertRepetition("LDPLCHLCC", (Structure)structure, rep);
    }

    public MFN_M05_LDPLCHLCC insertLDPLCHLCC(int rep) throws HL7Exception {
        return (MFN_M05_LDPLCHLCC)super.insertRepetition("LDPLCHLCC", rep);
    }

    public MFN_M05_LDPLCHLCC removeLDPLCHLCC(int rep) throws HL7Exception {
        return (MFN_M05_LDPLCHLCC)super.removeRepetition("LDPLCHLCC", rep);
    }
}

