/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.SRM_S01_PIDPV1PV2OBXDG1;
import ca.uhn.hl7v2.model.v231.group.SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE;
import ca.uhn.hl7v2.model.v231.segment.APR;
import ca.uhn.hl7v2.model.v231.segment.ARQ;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRM_S01
extends AbstractMessage {
    public SRM_S01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public SRM_S01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(ARQ.class, true, false);
            this.add(APR.class, false, false);
            this.add(NTE.class, false, true);
            this.add(SRM_S01_PIDPV1PV2OBXDG1.class, false, true);
            this.add(SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating SRM_S01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public ARQ getARQ() {
        return (ARQ)this.getTyped("ARQ", ARQ.class);
    }

    public APR getAPR() {
        return (APR)this.getTyped("APR", APR.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SRM_S01_PIDPV1PV2OBXDG1 getPIDPV1PV2OBXDG1() {
        return (SRM_S01_PIDPV1PV2OBXDG1)this.getTyped("PIDPV1PV2OBXDG1", SRM_S01_PIDPV1PV2OBXDG1.class);
    }

    public SRM_S01_PIDPV1PV2OBXDG1 getPIDPV1PV2OBXDG1(int rep) {
        return (SRM_S01_PIDPV1PV2OBXDG1)this.getTyped("PIDPV1PV2OBXDG1", rep, SRM_S01_PIDPV1PV2OBXDG1.class);
    }

    public int getPIDPV1PV2OBXDG1Reps() {
        return this.getReps("PIDPV1PV2OBXDG1");
    }

    public List<SRM_S01_PIDPV1PV2OBXDG1> getPIDPV1PV2OBXDG1All() throws HL7Exception {
        return this.getAllAsList("PIDPV1PV2OBXDG1", SRM_S01_PIDPV1PV2OBXDG1.class);
    }

    public void insertPIDPV1PV2OBXDG1(SRM_S01_PIDPV1PV2OBXDG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("PIDPV1PV2OBXDG1", (Structure)structure, rep);
    }

    public SRM_S01_PIDPV1PV2OBXDG1 insertPIDPV1PV2OBXDG1(int rep) throws HL7Exception {
        return (SRM_S01_PIDPV1PV2OBXDG1)super.insertRepetition("PIDPV1PV2OBXDG1", rep);
    }

    public SRM_S01_PIDPV1PV2OBXDG1 removePIDPV1PV2OBXDG1(int rep) throws HL7Exception {
        return (SRM_S01_PIDPV1PV2OBXDG1)super.removeRepetition("PIDPV1PV2OBXDG1", rep);
    }

    public SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE getRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE() {
        return (SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE)this.getTyped("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE", SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE.class);
    }

    public SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE getRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE(int rep) {
        return (SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE)this.getTyped("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE", rep, SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE.class);
    }

    public int getRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTEReps() {
        return this.getReps("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE");
    }

    public List<SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE> getRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTEAll() throws HL7Exception {
        return this.getAllAsList("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE", SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE.class);
    }

    public void insertRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE(SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE", (Structure)structure, rep);
    }

    public SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE insertRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE(int rep) throws HL7Exception {
        return (SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE)super.insertRepetition("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE", rep);
    }

    public SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE removeRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE(int rep) throws HL7Exception {
        return (SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE)super.removeRepetition("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE", rep);
    }
}

