/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AliasKeywords
implements CompilerPass {
    static final String ALIAS_NULL = "JSCompiler_alias_NULL";
    static final String ALIAS_TRUE = "JSCompiler_alias_TRUE";
    static final String ALIAS_FALSE = "JSCompiler_alias_FALSE";
    static final String ALIAS_THROW = "JSCompiler_alias_THROW";
    static final String ALIAS_VOID = "JSCompiler_alias_VOID";
    static final int MIN_OCCURRENCES_REQUIRED_TO_ALIAS_LITERAL = 6;
    static final int MIN_OCCURRENCES_REQUIRED_TO_ALIAS_THROW = AliasKeywords.estimateMinOccurrencesRequriedToAlias();
    private final AbstractCompiler compiler;
    private final List<AliasSpecification> aliasSpecifications;
    private final Map<Integer, AliasSpecification> aliasTypes;
    private final Set<String> aliasNames;

    static int estimateMinOccurrencesRequriedToAlias() {
        Node node = AliasKeywords.createAliasFunctionNode("TT");
        return InlineCostEstimator.getCost(node) / 2 + 1;
    }

    private static Node createAliasFunctionNode(String string) {
        Node node = Node.newString(38, "jscomp_throw_param");
        ArrayList arrayList = Lists.newArrayList((Object[])new Node[]{node.cloneNode()});
        Node node2 = new Node(49, node);
        Node node3 = new Node(125, node2);
        return NodeUtil.newFunctionNode(string, arrayList, node3, -1, -1);
    }

    AliasKeywords(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.aliasSpecifications = this.createAliasSpecifications();
        this.aliasTypes = Maps.newLinkedHashMap();
        this.aliasNames = Sets.newLinkedHashSet();
        for (AliasSpecification aliasSpecification : this.aliasSpecifications) {
            this.aliasTypes.put(aliasSpecification.getTokenId(), aliasSpecification);
            this.aliasNames.add(aliasSpecification.getAliasName());
        }
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, new FindAliasableNodes());
        if (this.needsAliases()) {
            this.addAliasNodes(this.compiler.getNodeForCodeInsertion(null));
            for (AliasSpecification aliasSpecification : this.aliasSpecifications) {
                aliasSpecification.doAlias(this.compiler);
            }
        }
    }

    private boolean needsAliases() {
        for (AliasSpecification aliasSpecification : this.aliasSpecifications) {
            if (aliasSpecification.nodes.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void addAliasNodes(Node node) {
        boolean bl = false;
        for (AliasSpecification aliasSpecification : this.aliasSpecifications) {
            if (!aliasSpecification.maybeInsertAliasDeclarationIntoParseTree(node)) continue;
            bl = true;
        }
        if (bl) {
            this.compiler.reportCodeChange();
        }
    }

    private boolean isAliasDefinition(Node node) {
        if (node.getType() != 38) {
            return false;
        }
        if (!this.isAliasName(node.getString())) {
            return false;
        }
        return node.getFirstChild() != null;
    }

    private boolean isAliasableType(int n) {
        return this.aliasTypes.containsKey(n);
    }

    private boolean isAliasName(String string) {
        return this.aliasNames.contains(string);
    }

    private List<AliasSpecification> createAliasSpecifications() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new KeywordAliasSpecification(ALIAS_FALSE, 43));
        arrayList.add(new KeywordAliasSpecification(ALIAS_NULL, 41));
        arrayList.add(new KeywordAliasSpecification(ALIAS_TRUE, 44));
        arrayList.add(new VoidKeywordAliasSpecification(ALIAS_VOID, 122));
        arrayList.add(new ThrowAliasSpecification(ALIAS_THROW));
        return arrayList;
    }

    private class VoidKeywordAliasSpecification
    extends AliasSpecification {
        VoidKeywordAliasSpecification(String string, int n) {
            super(string, n);
        }

        @Override
        public void visit(Node node, Node node2) {
            Node node3 = node.getFirstChild();
            if (node3.getType() == 39 && node3.getDouble() == 0.0) {
                super.visit(node, node2);
            }
        }

        @Override
        protected int minOccurrencesRequiredToAlias() {
            return 6;
        }

        @Override
        protected void aliasNode(Node node, Node node2) {
            Node node3 = NodeUtil.newName(AliasKeywords.this.compiler.getCodingConvention(), this.getAliasName(), node, this.getAliasName());
            node2.replaceChild(node, node3);
        }

        @Override
        protected void insertAliasDeclaration(Node node) {
            Node node2 = new Node(118);
            Node node3 = new Node(122, Node.newNumber(0.0));
            Node node4 = NodeUtil.newName(AliasKeywords.this.compiler.getCodingConvention(), this.getAliasName(), node2, this.getAliasName());
            node4.addChildToBack(node3);
            node2.addChildToBack(node4);
            node.addChildrenToFront(node2);
        }
    }

    private class KeywordAliasSpecification
    extends AliasSpecification {
        KeywordAliasSpecification(String string, int n) {
            super(string, n);
        }

        @Override
        protected int minOccurrencesRequiredToAlias() {
            return 6;
        }

        @Override
        protected void aliasNode(Node node, Node node2) {
            Node node3 = NodeUtil.newName(AliasKeywords.this.compiler.getCodingConvention(), this.getAliasName(), node, this.getAliasName());
            node2.replaceChild(node, node3);
        }

        @Override
        protected void insertAliasDeclaration(Node node) {
            Node node2 = new Node(118);
            Node node3 = new Node(this.getTokenId());
            Node node4 = NodeUtil.newName(AliasKeywords.this.compiler.getCodingConvention(), this.getAliasName(), node2, this.getAliasName());
            node4.addChildToBack(node3);
            node2.addChildToBack(node4);
            node.addChildrenToFront(node2);
        }
    }

    private class ThrowAliasSpecification
    extends AliasSpecification {
        ThrowAliasSpecification(String string) {
            super(string, 49);
        }

        @Override
        protected void aliasNode(Node node, Node node2) {
            Node node3 = NodeUtil.newName(AliasKeywords.this.compiler.getCodingConvention(), this.getAliasName(), node, this.getAliasName());
            Node node4 = new Node(37, node3, node.removeFirstChild());
            Node node5 = new Node(130, node4);
            node2.replaceChild(node, node5);
        }

        @Override
        protected void insertAliasDeclaration(Node node) {
            node.addChildToFront(AliasKeywords.createAliasFunctionNode(this.getAliasName()));
        }

        @Override
        protected int minOccurrencesRequiredToAlias() {
            return MIN_OCCURRENCES_REQUIRED_TO_ALIAS_THROW;
        }
    }

    private static abstract class AliasSpecification {
        private final Map<Node, Node> nodes = Maps.newHashMap();
        private boolean isAliased = false;
        private String aliasName;
        private int tokenId;

        public AliasSpecification(String string, int n) {
            this.aliasName = string;
            this.tokenId = n;
        }

        public void visit(Node node, Node node2) {
            this.nodes.put(node, node2);
        }

        boolean maybeInsertAliasDeclarationIntoParseTree(Node node) {
            if (this.nodes.size() >= this.minOccurrencesRequiredToAlias()) {
                this.insertAliasDeclaration(node);
                this.isAliased = true;
                return true;
            }
            return false;
        }

        public void doAlias(AbstractCompiler abstractCompiler) {
            if (this.isAliased) {
                for (Map.Entry<Node, Node> entry : this.nodes.entrySet()) {
                    Node node = entry.getKey();
                    Node node2 = entry.getValue();
                    this.aliasNode(node, node2);
                    abstractCompiler.reportCodeChange();
                }
            }
        }

        public int getTokenId() {
            return this.tokenId;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        protected abstract int minOccurrencesRequiredToAlias();

        protected abstract void insertAliasDeclaration(Node var1);

        protected abstract void aliasNode(Node var1, Node var2);
    }

    private class FindAliasableNodes
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindAliasableNodes() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            int n = node.getType();
            if (AliasKeywords.this.isAliasableType(n)) {
                this.visitAliasableNode(node, node2);
            } else if (n == 38) {
                this.visitNameNode(node);
            }
        }

        private void visitAliasableNode(Node node, Node node2) {
            AliasSpecification aliasSpecification = (AliasSpecification)AliasKeywords.this.aliasTypes.get(node.getType());
            aliasSpecification.visit(node, node2);
        }

        private void visitNameNode(Node node) {
            if (AliasKeywords.this.isAliasDefinition(node)) {
                throw new IllegalStateException("Existing alias definition for " + Node.tokenToName(node.getType()));
            }
        }
    }
}

