/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.List;

class AstParallelizer {
    public static final String TEMP_NAME = "JSC_TMP_PLACE_HOLDER";
    private final Predicate<Node> shouldSplit;
    private final Supplier<Node> placeHolderProvider;
    private final List<Node> forest;
    private final Node root;
    private final boolean includeRoot;
    private final List<DettachPoint> detachPointList;

    public AstParallelizer(Predicate<Node> predicate, Predicate<Node> predicate2, Supplier<Node> supplier, Node node, boolean bl) {
        this.shouldSplit = predicate;
        this.placeHolderProvider = supplier;
        this.root = node;
        this.includeRoot = bl;
        this.forest = Lists.newLinkedList();
        this.detachPointList = Lists.newLinkedList();
    }

    public static AstParallelizer createNewFunctionLevelAstParallelizer(Node node, boolean bl) {
        Predicate<Node> predicate = new Predicate<Node>(){

            public boolean apply(Node node) {
                return NodeUtil.isFunction(node);
            }
        };
        Predicate<Node> predicate2 = new Predicate<Node>(){

            public boolean apply(Node node) {
                return true;
            }
        };
        Supplier<Node> supplier = new Supplier<Node>(){

            public Node get() {
                return new Node(105, Node.newString(38, AstParallelizer.TEMP_NAME), new Node(83), new Node(125));
            }
        };
        return new AstParallelizer(predicate, predicate2, supplier, node, bl);
    }

    public static AstParallelizer createNewFileLevelAstParallelizer(Node node) {
        Predicate<Node> predicate = new Predicate<Node>(){

            public boolean apply(Node node) {
                String string = (String)node.getProp(16);
                return string != null;
            }
        };
        Supplier<Node> supplier = new Supplier<Node>(){

            public Node get() {
                return NodeUtil.newExpr(Node.newString(AstParallelizer.TEMP_NAME));
            }
        };
        Predicate<Node> predicate2 = new Predicate<Node>(){

            public boolean apply(Node node) {
                return node.getType() == 125;
            }
        };
        return new AstParallelizer(predicate, predicate2, supplier, node, false);
    }

    private void recordSplitPoint(Node node, Node node2, Node node3) {
        this.detachPointList.add(new DettachPoint(node, node2, node3));
    }

    public List<Node> split() {
        if (this.includeRoot) {
            this.forest.add(this.root);
        }
        this.split(this.root);
        return this.forest;
    }

    private void split(Node node) {
        Node node2 = node.getFirstChild();
        Node node3 = null;
        while (node2 != null) {
            Node node4 = node2.getNext();
            if (this.shouldSplit.apply((Object)node2)) {
                Node node5 = (Node)this.placeHolderProvider.get();
                if (node3 == null) {
                    this.forest.add(node.removeFirstChild());
                    node.addChildToFront(node5);
                } else {
                    node.addChildAfter(node5, node2);
                    node.removeChildAfter(node3);
                    this.forest.add(node2);
                }
                this.recordSplitPoint(node5, node3, node2);
                node3 = node5;
            } else {
                this.split(node2);
                node3 = node2;
            }
            node2 = node4;
        }
    }

    public void join() {
        while (!this.detachPointList.isEmpty()) {
            DettachPoint dettachPoint = this.detachPointList.remove(this.detachPointList.size() - 1);
            dettachPoint.reattach();
        }
    }

    private static class DettachPoint {
        private Node placeHolder;
        private Node before;
        private Node original;

        private DettachPoint(Node node, Node node2, Node node3) {
            this.placeHolder = node;
            this.before = node2;
            this.original = node3;
        }

        public void reattach() {
            if (this.placeHolder.getParent() != null) {
                if (this.before == null) {
                    this.placeHolder.getParent().addChildrenToFront(this.original);
                    this.placeHolder.getParent().removeChildAfter(this.original);
                } else {
                    this.placeHolder.getParent().addChildAfter(this.original, this.before);
                    this.placeHolder.getParent().removeChildAfter(this.original);
                }
            }
        }
    }
}

