/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;

class LineNumberCheck
implements NodeTraversal.Callback,
CompilerPass {
    static final DiagnosticType MISSING_LINE_INFO = DiagnosticType.error("JSC_MISSING_LINE_INFO", "No source location information associated with {0}.\nMost likely a Node has been created with settings the source file and line/column location.  Usually this is done using Node.copyInformationFrom and supplying a Node from the source AST.");
    private final AbstractCompiler compiler;
    private boolean requiresLineNumbers = false;

    LineNumberCheck(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    public void setCheckSubTree(Node node) {
        this.requiresLineNumbers = true;
        NodeTraversal.traverse(this.compiler, node, this);
    }

    @Override
    public void process(Node node, Node node2) {
        this.requiresLineNumbers = false;
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node.getType() == 132) {
            this.requiresLineNumbers = true;
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node.getType() == 132) {
            this.requiresLineNumbers = false;
        } else if (this.requiresLineNumbers && node.getLineno() == -1) {
            this.compiler.report(nodeTraversal.makeError(node, MISSING_LINE_INFO, node.toStringTree()));
        }
    }
}

