/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

class NodeIterators {
    private NodeIterators() {
    }

    static class LocalVarMotion
    implements Iterator<Node> {
        private final boolean valueHasSideEffects;
        private final FunctionlessLocalScope iterator;
        private final String varName;
        private Node lookAhead;

        static LocalVarMotion forVar(Node node, Node node2, Node node3) {
            Preconditions.checkArgument((node2.getType() == 118 ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)NodeUtil.isStatement(node2));
            return new LocalVarMotion(node, new FunctionlessLocalScope(node, node2, node3));
        }

        static LocalVarMotion forAssign(Node node, Node node2, Node node3, Node node4) {
            Preconditions.checkArgument((node2.getType() == 86 ? 1 : 0) != 0);
            Preconditions.checkArgument((node3.getType() == 130 ? 1 : 0) != 0);
            return new LocalVarMotion(node, new FunctionlessLocalScope(node2, node3, node4));
        }

        private LocalVarMotion(Node node, FunctionlessLocalScope functionlessLocalScope) {
            Preconditions.checkArgument((node.getType() == 38 ? 1 : 0) != 0);
            Node node2 = NodeUtil.getAssignedValue(node);
            this.varName = node.getString();
            this.valueHasSideEffects = node2 != null && NodeUtil.mayHaveSideEffects(node2);
            this.iterator = functionlessLocalScope;
            this.advanceLookAhead(true);
        }

        @Override
        public boolean hasNext() {
            return this.lookAhead != null;
        }

        @Override
        public Node next() {
            Node node = this.lookAhead;
            this.advanceLookAhead(false);
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        private void advanceLookAhead(boolean bl) {
            Node node;
            if (!bl) {
                if (this.lookAhead == null) {
                    return;
                }
                node = this.iterator.current();
                if (node.getType() == 38 && this.varName.equals(node.getString())) {
                    this.lookAhead = null;
                    return;
                }
            }
            if (!this.iterator.hasNext()) {
                this.lookAhead = null;
                return;
            }
            node = this.iterator.next();
            Node node2 = this.iterator.currentParent();
            int n = node.getType();
            if (this.valueHasSideEffects && n == 38 && !this.varName.equals(node.getString())) {
                boolean bl2 = false;
                if (node2 == null) {
                    bl2 = true;
                } else {
                    boolean bl3;
                    boolean bl4 = node2.getType() == 86 && node == node2.getFirstChild();
                    boolean bl5 = bl3 = node2.getType() == 118;
                    if (!bl4 && !bl3) {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    this.lookAhead = null;
                    return;
                }
            }
            if (NodeUtil.nodeTypeMayHaveSideEffects(node) && n != 38 || n == 38 && node2.getType() == 120) {
                this.lookAhead = null;
                return;
            }
            this.lookAhead = node;
        }
    }

    static class FunctionlessLocalScope
    implements Iterator<Node> {
        private final Stack<Node> ancestors = new Stack();

        FunctionlessLocalScope(Node ... nodeArray) {
            Preconditions.checkArgument((nodeArray.length > 0 ? 1 : 0) != 0);
            for (Node node : nodeArray) {
                if (node.getType() == 105) break;
                this.ancestors.add(0, node);
            }
        }

        @Override
        public boolean hasNext() {
            return this.ancestors.size() != 1 || this.ancestors.peek().getNext() != null;
        }

        @Override
        public Node next() {
            Node node = this.ancestors.pop();
            if (node.getNext() == null) {
                node = this.ancestors.peek();
                if (node.getType() == 105) {
                    return this.next();
                }
            } else {
                node = node.getNext();
                this.ancestors.push(node);
                if (node.getType() == 105) {
                    return this.next();
                }
                while (node.hasChildren()) {
                    node = node.getFirstChild();
                    this.ancestors.push(node);
                    if (node.getType() != 105) continue;
                    return this.next();
                }
            }
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        protected Node current() {
            return this.ancestors.peek();
        }

        protected Node currentParent() {
            return this.ancestors.size() >= 2 ? (Node)this.ancestors.get(this.ancestors.size() - 2) : null;
        }

        List<Node> currentAncestors() {
            ArrayList arrayList = Lists.newArrayList(this.ancestors);
            Collections.reverse(arrayList);
            return arrayList;
        }
    }
}

