/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.regex.Pattern;

class PeepholeSubstituteAlternateSyntax
extends AbstractPeepholeOptimization {
    private static final int AND_PRECEDENCE = NodeUtil.precedence(101);
    private static final int OR_PRECEDENCE = NodeUtil.precedence(100);
    private static final int NOT_PRECEDENCE = NodeUtil.precedence(26);
    private final boolean doCommaSpliting;
    static final DiagnosticType INVALID_REGULAR_EXPRESSION_FLAGS = DiagnosticType.error("JSC_INVALID_REGULAR_EXPRESSION_FLAGS", "Invalid flags to RegExp constructor: {0}");
    static final Predicate<Node> DONT_TRAVERSE_FUNCTIONS_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node node) {
            return node.getType() != 105;
        }
    };
    private static final ImmutableSet<String> STANDARD_OBJECT_CONSTRUCTORS = ImmutableSet.of((Object)"Object", (Object)"Array", (Object)"RegExp", (Object)"Error");
    private static final Pattern REGEXP_FLAGS_RE = Pattern.compile("^[gmi]*$");

    PeepholeSubstituteAlternateSyntax(boolean bl) {
        this.doCommaSpliting = bl;
    }

    @Override
    public Node optimizeSubtree(Node node) {
        switch (node.getType()) {
            case 4: {
                Node node2 = this.tryRemoveRedundantExit(node);
                if (node2 != node) {
                    return node2;
                }
                node2 = this.tryReplaceExitWithBreak(node);
                if (node2 != node) {
                    return node2;
                }
                return this.tryReduceReturn(node);
            }
            case 49: {
                Node node3 = this.tryRemoveRedundantExit(node);
                if (node3 != node) {
                    return node3;
                }
                return this.tryReplaceExitWithBreak(node);
            }
            case 26: {
                this.tryMinimizeCondition(node.getFirstChild());
                return this.tryMinimizeNot(node);
            }
            case 108: {
                this.tryMinimizeCondition(node.getFirstChild());
                return this.tryMinimizeIf(node);
            }
            case 130: {
                this.tryMinimizeCondition(node.getFirstChild());
                return node;
            }
            case 98: {
                this.tryMinimizeCondition(node.getFirstChild());
                return node;
            }
            case 113: 
            case 114: {
                this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                return node;
            }
            case 115: {
                if (!NodeUtil.isForIn(node)) {
                    this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                }
                return node;
            }
            case 43: 
            case 44: {
                return this.reduceTrueFalse(node);
            }
            case 30: {
                node = this.tryFoldStandardConstructors(node);
                if (node.getType() != 37) {
                    return node;
                }
            }
            case 37: {
                return this.tryFoldLiteralConstructor(node);
            }
            case 85: {
                return this.tryFoldComma(node);
            }
            case 38: {
                return this.tryReplaceUndefined(node);
            }
        }
        return node;
    }

    private Node tryFoldComma(Node node) {
        if (!this.doCommaSpliting) {
            return node;
        }
        Node node2 = node.getParent();
        Node node3 = node.getFirstChild();
        Node node4 = node.getLastChild();
        if (node2.getType() == 130 && node2.getParent().getType() != 126) {
            node.detachChildren();
            node2.replaceChild(node, node3);
            Node node5 = new Node(130, node4);
            node5.copyInformationFrom(node);
            node2.getParent().addChildAfter(node5, node2);
            this.reportCodeChange();
            return node3;
        }
        return node;
    }

    private Node tryReplaceUndefined(Node node) {
        if (this.isASTNormalized() && NodeUtil.isUndefined(node) && !NodeUtil.isLhs(node, node.getParent())) {
            Node node2 = NodeUtil.newUndefinedNode(node);
            node.getParent().replaceChild(node, node2);
            this.reportCodeChange();
            return node2;
        }
        return node;
    }

    private Node tryReduceReturn(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            switch (node2.getType()) {
                case 122: {
                    Node node3 = node2.getFirstChild();
                    if (this.mayHaveSideEffects(node3)) break;
                    node.removeFirstChild();
                    this.reportCodeChange();
                    break;
                }
                case 38: {
                    String string = node2.getString();
                    if (!string.equals("undefined")) break;
                    node.removeFirstChild();
                    this.reportCodeChange();
                }
            }
        }
        return node;
    }

    private Node tryReplaceExitWithBreak(Node node) {
        Node node2 = node.getFirstChild();
        Node node3 = node;
        while (!ControlFlowAnalysis.isBreakTarget(node3, null)) {
            if (NodeUtil.isFunction(node3) || node3.getType() == 132) {
                return node;
            }
            node3 = node3.getParent();
        }
        Node node4 = ControlFlowAnalysis.computeFollowNode(node3);
        Node node5 = node4;
        if (node5 != (node4 = this.skipFinallyNodes(node4)) && !this.isPure(node2)) {
            return node;
        }
        if (node4 == null && (node.getType() == 49 || node2 != null)) {
            return node;
        }
        if (node4 == null || this.areMatchingExits(node, node4)) {
            Node node6 = new Node(116);
            node.getParent().replaceChild(node, node6);
            this.reportCodeChange();
            return node6;
        }
        return node;
    }

    private Node tryRemoveRedundantExit(Node node) {
        Node node2 = node.getFirstChild();
        Node node3 = ControlFlowAnalysis.computeFollowNode(node);
        Node node4 = node3;
        if (node4 != (node3 = this.skipFinallyNodes(node3)) && !this.isPure(node2)) {
            return node;
        }
        if (node3 == null && (node.getType() == 49 || node2 != null)) {
            return node;
        }
        if (node3 == null || this.areMatchingExits(node, node3)) {
            node.detachFromParent();
            this.reportCodeChange();
            return null;
        }
        return node;
    }

    boolean isPure(Node node) {
        return node == null || !NodeUtil.canBeSideEffected(node) && !NodeUtil.mayHaveSideEffects(node);
    }

    Node skipFinallyNodes(Node node) {
        while (node != null && NodeUtil.isTryFinallyNode(node.getParent(), node)) {
            node = ControlFlowAnalysis.computeFollowNode(node);
        }
        return node;
    }

    boolean areMatchingExits(Node node, Node node2) {
        return node.isEquivalentTo(node2) && (!this.isExceptionPossible(node) || this.getExceptionHandler(node) == this.getExceptionHandler(node2));
    }

    boolean isExceptionPossible(Node node) {
        Preconditions.checkState((node.getType() == 4 || node.getType() == 49 ? 1 : 0) != 0);
        return node.getType() == 49 || node.hasChildren() && !NodeUtil.isLiteralValue(node.getLastChild(), true);
    }

    Node getExceptionHandler(Node node) {
        return ControlFlowAnalysis.getExceptionHandler(node);
    }

    private Node tryMinimizeNot(Node node) {
        int n;
        Node node2 = node.getParent();
        Node node3 = node.getFirstChild();
        switch (node3.getType()) {
            case 12: {
                n = 13;
                break;
            }
            case 13: {
                n = 12;
                break;
            }
            case 45: {
                n = 46;
                break;
            }
            case 46: {
                n = 45;
                break;
            }
            default: {
                return node;
            }
        }
        Node node4 = node.removeFirstChild();
        node4.setType(n);
        node2.replaceChild(node, node4);
        this.reportCodeChange();
        return node4;
    }

    private Node tryMinimizeIf(Node node) {
        Node node2 = node.getParent();
        Node node3 = node.getFirstChild();
        if (NodeUtil.isLiteralValue(node3, true)) {
            return node;
        }
        Node node4 = node3.getNext();
        Node node5 = node4.getNext();
        if (node5 == null) {
            Node node6;
            Node node7;
            Node node8;
            Node node9;
            if (this.isFoldableExpressBlock(node4)) {
                Node node10 = this.getBlockExpression(node4);
                if (this.isPropertyAssignmentInExpression(node10)) {
                    return node;
                }
                if (node3.getType() == 26) {
                    if (this.isLowerPrecedenceInExpression(node3, OR_PRECEDENCE) && this.isLowerPrecedenceInExpression(node10.getFirstChild(), OR_PRECEDENCE)) {
                        return node;
                    }
                    Node node11 = new Node(100, node3.removeFirstChild(), node10.removeFirstChild()).copyInformationFrom(node);
                    Node node12 = NodeUtil.newExpr(node11);
                    node2.replaceChild(node, node12);
                    this.reportCodeChange();
                    return node12;
                }
                if (this.isLowerPrecedenceInExpression(node3, AND_PRECEDENCE) && this.isLowerPrecedenceInExpression(node10.getFirstChild(), AND_PRECEDENCE)) {
                    return node;
                }
                node.removeChild(node3);
                Node node13 = new Node(101, node3, node10.removeFirstChild()).copyInformationFrom(node);
                Node node14 = NodeUtil.newExpr(node13);
                node2.replaceChild(node, node14);
                this.reportCodeChange();
                return node14;
            }
            if (NodeUtil.isStatementBlock(node4) && node4.hasOneChild() && (node9 = node4.getFirstChild()).getType() == 108 && (node8 = (node7 = (node6 = node9.getFirstChild()).getNext()).getNext()) == null && (!this.isLowerPrecedenceInExpression(node3, AND_PRECEDENCE) || !this.isLowerPrecedenceInExpression(node6, AND_PRECEDENCE))) {
                node.detachChildren();
                node.addChildToBack(new Node(101, node3, node6.detachFromParent()).copyInformationFrom(node3));
                node.addChildrenToBack(node7.detachFromParent());
                this.reportCodeChange();
                return node;
            }
            return node;
        }
        this.tryRemoveRepeatedStatements(node);
        if (node3.getType() == 26 && !this.consumesDanglingElse(node5)) {
            node.replaceChild(node3, node3.removeFirstChild());
            node.removeChild(node4);
            node.addChildToBack(node4);
            this.reportCodeChange();
            return node;
        }
        if (this.isReturnExpressBlock(node4) && this.isReturnExpressBlock(node5)) {
            Node node15 = this.getBlockReturnExpression(node4);
            Node node16 = this.getBlockReturnExpression(node5);
            node.removeChild(node3);
            node15.detachFromParent();
            node16.detachFromParent();
            Node node17 = new Node(98, node3, node15, node16).copyInformationFrom(node);
            Node node18 = new Node(4, node17);
            node2.replaceChild(node, node18);
            this.reportCodeChange();
            return node18;
        }
        boolean bl = this.isFoldableExpressBlock(node4);
        boolean bl2 = this.isFoldableExpressBlock(node5);
        if (bl && bl2) {
            Node node19;
            Node node20 = this.getBlockExpression(node4).getFirstChild();
            Node node21 = this.getBlockExpression(node5).getFirstChild();
            if (node20.getType() == node21.getType() && NodeUtil.isAssignmentOp(node20) && this.areNodesEqualForInlining(node19 = node20.getFirstChild(), node21.getFirstChild()) && !this.mayEffectMutableState(node19)) {
                node.removeChild(node3);
                Node node22 = node20.removeFirstChild();
                Node node23 = node20.removeFirstChild();
                Node node24 = node21.getLastChild();
                node21.removeChild(node24);
                Node node25 = new Node(98, node3, node23, node24).copyInformationFrom(node);
                Node node26 = new Node(node20.getType(), node22, node25).copyInformationFrom(node20);
                Node node27 = NodeUtil.newExpr(node26);
                node2.replaceChild(node, node27);
                this.reportCodeChange();
                return node27;
            }
            node.removeChild(node3);
            node20.detachFromParent();
            node21.detachFromParent();
            node19 = new Node(98, node3, node20, node21).copyInformationFrom(node);
            Node node28 = NodeUtil.newExpr(node19);
            node2.replaceChild(node, node28);
            this.reportCodeChange();
            return node28;
        }
        boolean bl3 = this.isVarBlock(node4);
        boolean bl4 = this.isVarBlock(node5);
        if (bl3 && bl2 && NodeUtil.isAssign(this.getBlockExpression(node5).getFirstChild())) {
            Node node29 = this.getBlockVar(node4);
            Node node30 = this.getBlockExpression(node5).getFirstChild();
            Node node31 = node29.getFirstChild();
            Node node32 = node30.getFirstChild();
            if (node31.hasChildren() && node32.getType() == 38 && node31.getString().equals(node32.getString())) {
                Node node33 = node31.removeChildren();
                Node node34 = node30.getLastChild().detachFromParent();
                node3.detachFromParent();
                Node node35 = new Node(98, node3, node33, node34).copyInformationFrom(node);
                node29.detachFromParent();
                node31.addChildrenToBack(node35);
                node2.replaceChild(node, node29);
                this.reportCodeChange();
                return node29;
            }
        } else if (bl4 && bl && NodeUtil.isAssign(this.getBlockExpression(node4).getFirstChild())) {
            Node node36 = this.getBlockVar(node5);
            Node node37 = this.getBlockExpression(node4).getFirstChild();
            Node node38 = node37.getFirstChild();
            Node node39 = node36.getFirstChild();
            if (node39.hasChildren() && node38.getType() == 38 && node38.getString().equals(node39.getString())) {
                Node node40 = node37.getLastChild().detachFromParent();
                Node node41 = node39.removeChildren();
                node3.detachFromParent();
                Node node42 = new Node(98, node3, node40, node41).copyInformationFrom(node);
                node36.detachFromParent();
                node39.addChildrenToBack(node42);
                node2.replaceChild(node, node36);
                this.reportCodeChange();
                return node36;
            }
        }
        return node;
    }

    private void tryRemoveRepeatedStatements(Node node) {
        Preconditions.checkState((node.getType() == 108 ? 1 : 0) != 0);
        Node node2 = node.getParent();
        if (!NodeUtil.isStatementBlock(node2)) {
            return;
        }
        Node node3 = node.getFirstChild();
        Node node4 = node3.getNext();
        Node node5 = node4.getNext();
        Preconditions.checkNotNull((Object)node4);
        Preconditions.checkNotNull((Object)node5);
        while (true) {
            Node node6 = node4.getLastChild();
            Node node7 = node5.getLastChild();
            if (node6 == null || node7 == null || !this.areNodesEqualForInlining(node6, node7)) break;
            node6.detachFromParent();
            node7.detachFromParent();
            node2.addChildAfter(node6, node);
            this.reportCodeChange();
        }
    }

    private boolean isFoldableExpressBlock(Node node) {
        if (node.getType() == 125 && node.hasOneChild()) {
            Node node2 = node.getFirstChild();
            if (node2.getType() == 130) {
                if (node2.getFirstChild().getType() == 37) {
                    Node node3 = node2.getFirstChild().getFirstChild();
                    if (node3.getType() == 35) {
                        return false;
                    }
                    if (node3.getType() == 33 && node3.getLastChild().getString().startsWith("on")) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private Node getBlockExpression(Node node) {
        Preconditions.checkState((boolean)this.isFoldableExpressBlock(node));
        return node.getFirstChild();
    }

    private boolean isReturnExpressBlock(Node node) {
        Node node2;
        if (node.getType() == 125 && node.hasOneChild() && (node2 = node.getFirstChild()).getType() == 4) {
            return node2.hasOneChild();
        }
        return false;
    }

    private Node getBlockReturnExpression(Node node) {
        Preconditions.checkState((boolean)this.isReturnExpressBlock(node));
        return node.getFirstChild().getFirstChild();
    }

    private boolean isVarBlock(Node node) {
        Node node2;
        if (node.getType() == 125 && node.hasOneChild() && (node2 = node.getFirstChild()).getType() == 118) {
            return node2.hasOneChild();
        }
        return false;
    }

    private Node getBlockVar(Node node) {
        Preconditions.checkState((boolean)this.isVarBlock(node));
        return node.getFirstChild();
    }

    private boolean consumesDanglingElse(Node node) {
        block4: while (true) {
            switch (node.getType()) {
                case 108: {
                    if (node.getChildCount() < 3) {
                        return true;
                    }
                    node = node.getLastChild();
                    continue block4;
                }
                case 113: 
                case 115: 
                case 119: {
                    node = node.getLastChild();
                    continue block4;
                }
            }
            break;
        }
        return false;
    }

    private boolean isLowerPrecedenceInExpression(Node node, final int n) {
        Predicate<Node> predicate = new Predicate<Node>(){

            public boolean apply(Node node) {
                return NodeUtil.precedence(node.getType()) < n;
            }
        };
        return NodeUtil.has(node, predicate, DONT_TRAVERSE_FUNCTIONS_PREDICATE);
    }

    private boolean isLowerPrecedence(Node node, int n) {
        return NodeUtil.precedence(node.getType()) < n;
    }

    private boolean isHigherPrecedence(Node node, int n) {
        return NodeUtil.precedence(node.getType()) > n;
    }

    private boolean isPropertyAssignmentInExpression(Node node) {
        Predicate<Node> predicate = new Predicate<Node>(){

            public boolean apply(Node node) {
                return node.getType() == 33 && node.getParent().getType() == 86;
            }
        };
        return NodeUtil.has(node, predicate, DONT_TRAVERSE_FUNCTIONS_PREDICATE);
    }

    private Node tryMinimizeCondition(Node node) {
        Node node2 = node.getParent();
        switch (node.getType()) {
            case 26: {
                Node node3 = node.getFirstChild();
                switch (node3.getType()) {
                    case 26: {
                        Node node4 = node3.removeFirstChild();
                        node2.replaceChild(node, node4);
                        this.reportCodeChange();
                        return node4;
                    }
                    case 100: 
                    case 101: {
                        Node node5;
                        Node node6;
                        int n;
                        Node node7 = node3.getFirstChild();
                        Node node8 = node3.getLastChild();
                        if (node7.getType() != 26 && node8.getType() != 26) {
                            n = NodeUtil.precedence(node3.getType());
                            if (this.isLowerPrecedence(node7, NOT_PRECEDENCE) && this.isHigherPrecedence(node7, n) || this.isLowerPrecedence(node8, NOT_PRECEDENCE) && this.isHigherPrecedence(node8, n)) {
                                return node;
                            }
                        }
                        if (node7.getType() == 26) {
                            node6 = node7.removeFirstChild();
                        } else {
                            node7.detachFromParent();
                            node6 = new Node(26, node7).copyInformationFrom(node7);
                        }
                        if (node8.getType() == 26) {
                            node5 = node8.removeFirstChild();
                        } else {
                            node8.detachFromParent();
                            node5 = new Node(26, node8).copyInformationFrom(node8);
                        }
                        n = node3.getType() == 101 ? 100 : 101;
                        Node node9 = new Node(n, node6, node5);
                        node2.replaceChild(node, node9);
                        this.reportCodeChange();
                        return node9;
                    }
                }
                TernaryValue ternaryValue = NodeUtil.getPureBooleanValue(node3);
                if (ternaryValue != TernaryValue.UNKNOWN) {
                    boolean bl = ternaryValue.not().toBoolean(true);
                    int n = bl ? 1 : 0;
                    return this.maybeReplaceChildWithNumber(node, node2, n);
                }
                return node;
            }
            case 100: 
            case 101: {
                Node node10 = node.getFirstChild();
                Node node11 = node.getLastChild();
                node10 = this.tryMinimizeCondition(node10);
                node11 = this.tryMinimizeCondition(node11);
                TernaryValue ternaryValue = NodeUtil.getPureBooleanValue(node11);
                if (NodeUtil.getPureBooleanValue(node11) != TernaryValue.UNKNOWN) {
                    int n = node.getType();
                    Node node12 = null;
                    boolean bl = ternaryValue.toBoolean(true);
                    if (n == 100 && !bl || n == 101 && bl) {
                        node12 = node10;
                    } else if (!this.mayHaveSideEffects(node10)) {
                        node12 = node11;
                    }
                    if (node12 != null) {
                        node.detachChildren();
                        node2.replaceChild(node, node12);
                        this.reportCodeChange();
                        return node12;
                    }
                }
                return node;
            }
            case 98: {
                Node node13 = node.getFirstChild();
                Node node14 = node.getFirstChild().getNext();
                Node node15 = node.getLastChild();
                node14 = this.tryMinimizeCondition(node14);
                node15 = this.tryMinimizeCondition(node15);
                Node node16 = null;
                TernaryValue ternaryValue = NodeUtil.getPureBooleanValue(node14);
                TernaryValue ternaryValue2 = NodeUtil.getPureBooleanValue(node15);
                if (ternaryValue == TernaryValue.TRUE && ternaryValue2 == TernaryValue.FALSE) {
                    node13.detachFromParent();
                    node16 = node13;
                } else if (ternaryValue == TernaryValue.FALSE && ternaryValue2 == TernaryValue.TRUE) {
                    node13.detachFromParent();
                    node16 = new Node(26, node13);
                } else if (ternaryValue == TernaryValue.TRUE) {
                    node.detachChildren();
                    node16 = new Node(100, node13, node15);
                } else if (ternaryValue2 == TernaryValue.FALSE) {
                    node.detachChildren();
                    node16 = new Node(101, node13, node14);
                }
                if (node16 != null) {
                    node2.replaceChild(node, node16);
                    node = node16;
                    this.reportCodeChange();
                }
                return node;
            }
        }
        TernaryValue ternaryValue = NodeUtil.getPureBooleanValue(node);
        if (ternaryValue != TernaryValue.UNKNOWN) {
            boolean bl = ternaryValue.toBoolean(true);
            int n = bl ? 1 : 0;
            return this.maybeReplaceChildWithNumber(node, node2, n);
        }
        return node;
    }

    private Node maybeReplaceChildWithNumber(Node node, Node node2, int n) {
        Node node3 = Node.newNumber(n);
        if (!node3.isEquivalentTo(node)) {
            node2.replaceChild(node, node3);
            this.reportCodeChange();
            return node3;
        }
        return node;
    }

    private Node tryFoldStandardConstructors(Node node) {
        String string;
        Preconditions.checkState((node.getType() == 30 ? 1 : 0) != 0);
        if (this.isASTNormalized() && node.getFirstChild().getType() == 38 && STANDARD_OBJECT_CONSTRUCTORS.contains((Object)(string = node.getFirstChild().getString()))) {
            node.setType(37);
            this.reportCodeChange();
        }
        return node;
    }

    private Node tryFoldLiteralConstructor(Node node) {
        Preconditions.checkArgument((node.getType() == 37 || node.getType() == 30 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        Node node3 = null;
        if (this.isASTNormalized() && 38 == node2.getType()) {
            Node node4;
            FoldArrayAction foldArrayAction;
            boolean bl;
            String string = node2.getString();
            if ("RegExp".equals(string)) {
                return this.tryFoldRegularExpressionConstructor(node);
            }
            boolean bl2 = bl = node2.getNext() != null;
            if ("Object".equals(string) && !bl) {
                node3 = new Node(64);
            } else if ("Array".equals(string) && ((foldArrayAction = this.isSafeToFoldArrayConstructor(node4 = node2.getNext())) == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS || foldArrayAction == FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS)) {
                node3 = new Node(63);
                node.removeChildren();
                if (foldArrayAction == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS) {
                    node3.addChildrenToFront(node4);
                }
            }
            if (node3 != null) {
                node.getParent().replaceChild(node, node3);
                this.reportCodeChange();
                return node3;
            }
        }
        return node;
    }

    private FoldArrayAction isSafeToFoldArrayConstructor(Node node) {
        FoldArrayAction foldArrayAction = FoldArrayAction.NOT_SAFE_TO_FOLD;
        if (node == null) {
            foldArrayAction = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
        } else if (node.getNext() != null) {
            foldArrayAction = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
        } else {
            switch (node.getType()) {
                case 40: {
                    foldArrayAction = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
                case 39: {
                    if (node.getDouble() != 0.0) break;
                    foldArrayAction = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
                    break;
                }
                case 63: {
                    foldArrayAction = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
            }
        }
        return foldArrayAction;
    }

    private Node tryFoldRegularExpressionConstructor(Node node) {
        Node node2;
        Node node3 = node.getParent();
        Node node4 = node.getFirstChild();
        Node node5 = node4.getNext();
        Node node6 = node2 = null != node5 ? node5.getNext() : null;
        if (null == node5 || null != node2 && null != node2.getNext()) {
            return node;
        }
        if (!(node5.getType() != 40 || "".equals(node5.getString()) || node5.getString().length() >= 100 || null != node2 && node2.getType() != 40 || !this.isEcmaScript5OrGreater() && PeepholeSubstituteAlternateSyntax.containsUnicodeEscape(node5.getString()))) {
            Node node7;
            node5 = PeepholeSubstituteAlternateSyntax.makeForwardSlashBracketSafe(node5);
            if (null == node2 || "".equals(node2.getString())) {
                node7 = new Node(47, node5);
            } else {
                if (!PeepholeSubstituteAlternateSyntax.areValidRegexpFlags(node2.getString())) {
                    this.error(INVALID_REGULAR_EXPRESSION_FLAGS, node2);
                    return node;
                }
                if (!this.areSafeFlagsToFold(node2.getString())) {
                    return node;
                }
                node.removeChild(node2);
                node7 = new Node(47, node5, node2);
            }
            node3.replaceChild(node, node7);
            this.reportCodeChange();
            return node7;
        }
        return node;
    }

    private Node reduceTrueFalse(Node node) {
        Node node2 = new Node(26, Node.newNumber(node.getType() == 44 ? 0.0 : 1.0));
        node2.copyInformationFromForTree(node);
        node.getParent().replaceChild(node, node2);
        this.reportCodeChange();
        return node2;
    }

    private static boolean areValidRegexpFlags(String string) {
        return REGEXP_FLAGS_RE.matcher(string).matches();
    }

    private boolean areSafeFlagsToFold(String string) {
        return this.isEcmaScript5OrGreater() || string.indexOf(103) < 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Node makeForwardSlashBracketSafe(Node node) {
        String string = node.getString();
        StringBuilder stringBuilder = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        block13: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    bl = !bl;
                    continue block13;
                }
                case '/': {
                    if (bl || bl2) break;
                    if (null == stringBuilder) {
                        stringBuilder = new StringBuilder(string.length() + 16);
                    }
                    stringBuilder.append(string, n, i).append('\\');
                    n = i;
                    break;
                }
                case '[': {
                    if (bl) break;
                    bl2 = true;
                    break;
                }
                case ']': {
                    if (bl) break;
                    bl2 = false;
                    break;
                }
                case '\n': 
                case '\r': 
                case '\u2028': 
                case '\u2029': {
                    if (null == stringBuilder) {
                        stringBuilder = new StringBuilder(string.length() + 16);
                    }
                    if (bl) {
                        stringBuilder.append(string, n, i - 1);
                    } else {
                        stringBuilder.append(string, n, i);
                    }
                    switch (c) {
                        case '\r': {
                            stringBuilder.append("\\r");
                            break;
                        }
                        case '\n': {
                            stringBuilder.append("\\n");
                            break;
                        }
                        case '\u2028': {
                            stringBuilder.append("\\u2028");
                            break;
                        }
                        case '\u2029': {
                            stringBuilder.append("\\u2029");
                            break;
                        }
                    }
                    n = i + 1;
                }
            }
            bl = false;
        }
        if (null == stringBuilder) {
            return node.cloneTree();
        }
        stringBuilder.append(string, n, string.length());
        return Node.newString(stringBuilder.toString()).copyInformationFrom(node);
    }

    static boolean containsUnicodeEscape(String string) {
        String string2 = CodeGenerator.regexpEscape(string);
        int n = -1;
        while ((n = string2.indexOf("\\u", n + 1)) >= 0) {
            int n2 = 0;
            while (n - n2 > 0 && '\\' == string2.charAt(n - n2 - 1)) {
                ++n2;
            }
            if (0 != (n2 & 1)) continue;
            return true;
        }
        return false;
    }

    private static enum FoldArrayAction {
        NOT_SAFE_TO_FOLD,
        SAFE_TO_FOLD_WITH_ARGS,
        SAFE_TO_FOLD_WITHOUT_ARGS;

    }
}

