/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;

class PrepareAst
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean checkOnly;

    PrepareAst(AbstractCompiler abstractCompiler) {
        this(abstractCompiler, false);
    }

    PrepareAst(AbstractCompiler abstractCompiler, boolean bl) {
        this.compiler = abstractCompiler;
        this.checkOnly = bl;
    }

    private void reportChange() {
        if (this.checkOnly) {
            Preconditions.checkState((boolean)false, (Object)"normalizeNodeType constraints violated");
        }
    }

    @Override
    public void process(Node node, Node node2) {
        if (this.checkOnly) {
            this.normalizeNodeTypes(node2);
        } else {
            if (node != null) {
                NodeTraversal.traverse(this.compiler, node, new PrepareAnnotations(this.compiler));
            }
            if (node2 != null) {
                NodeTraversal.traverse(this.compiler, node2, new PrepareAnnotations(this.compiler));
            }
        }
    }

    private void normalizeNodeTypes(Node node) {
        if (node.getType() == 129) {
            node.setType(130);
            this.reportChange();
        }
        if (node.getType() == 105) {
            Preconditions.checkState((node.getProp(5) == null ? 1 : 0) != 0);
        }
        this.normalizeBlocks(node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            Preconditions.checkState((node2.getParent() == node ? 1 : 0) != 0);
            this.normalizeNodeTypes(node2);
        }
    }

    private void normalizeBlocks(Node node) {
        if (NodeUtil.isControlStructure(node) && node.getType() != 126 && node.getType() != 110) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (!NodeUtil.isControlStructureCodeBlock(node, node2) || node2.getType() == 125) continue;
                Node node3 = new Node(125, node.getLineno(), node.getCharno());
                node3.copyInformationFrom(node);
                node.replaceChild(node2, node3);
                if (node2.getType() != 124) {
                    node3.addChildrenToFront(node2);
                } else {
                    node3.setWasEmptyNode(true);
                }
                node2 = node3;
                this.reportChange();
            }
        }
    }

    static class PrepareAnnotations
    implements NodeTraversal.Callback {
        private final CodingConvention convention;

        PrepareAnnotations(AbstractCompiler abstractCompiler) {
            this.convention = abstractCompiler.getCodingConvention();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 64) {
                this.normalizeObjectLiteralAnnotations(node);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 37: {
                    this.annotateCalls(node);
                    break;
                }
                case 105: {
                    this.annotateFunctions(node, node2);
                    this.annotateDispatchers(node, node2);
                }
            }
        }

        private void normalizeObjectLiteralAnnotations(Node node) {
            Preconditions.checkState((node.getType() == 64 ? 1 : 0) != 0);
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                Node node3 = node2.getFirstChild();
                this.normalizeObjectLiteralKeyAnnotations(node, node2, node3);
            }
        }

        private void annotateCalls(Node node) {
            Preconditions.checkState((node.getType() == 37 ? 1 : 0) != 0);
            Node node2 = node.getFirstChild();
            if (!NodeUtil.isGet(node2)) {
                node.putBooleanProp(50, true);
            }
            if (node2.getType() == 38 && "eval".equals(node2.getString())) {
                node2.putBooleanProp(49, true);
            }
        }

        private void annotateDispatchers(Node node, Node node2) {
            Preconditions.checkState((node.getType() == 105 ? 1 : 0) != 0);
            if (node2.getJSDocInfo() != null && node2.getJSDocInfo().isJavaDispatch() && node2.getType() == 86) {
                Preconditions.checkState((node2.getLastChild() == node ? 1 : 0) != 0);
                node.putBooleanProp(47, true);
            }
        }

        private void normalizeObjectLiteralKeyAnnotations(Node node, Node node2, Node node3) {
            Preconditions.checkState((node.getType() == 64 ? 1 : 0) != 0);
            if (node2.getJSDocInfo() != null && node3.getType() == 105) {
                node3.setJSDocInfo(node2.getJSDocInfo());
            }
        }

        private void annotateFunctions(Node node, Node node2) {
            JSDocInfo jSDocInfo = NodeUtil.getFunctionInfo(node);
            Node node3 = node.getFirstChild().getNext();
            for (Node node4 = node3.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                JSTypeExpression jSTypeExpression;
                String string = node4.getString();
                JSTypeExpression jSTypeExpression2 = jSTypeExpression = jSDocInfo == null ? null : jSDocInfo.getParameterType(string);
                if (this.convention.isOptionalParameter(node4) || jSTypeExpression != null && jSTypeExpression.isOptionalArg()) {
                    node4.putBooleanProp(44, true);
                }
                if (!this.convention.isVarArgsParameter(node4) && (jSTypeExpression == null || !jSTypeExpression.isVarArgs())) continue;
                node4.putBooleanProp(45, true);
            }
        }
    }
}

