/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.Node;
import java.util.Set;

class SimpleFunctionAliasAnalysis {
    private Set<Node> aliasedFunctions;
    private Set<Node> functionsExposedToCallOrApply;

    SimpleFunctionAliasAnalysis() {
    }

    public boolean isAliased(Node node) {
        Preconditions.checkNotNull(this.aliasedFunctions);
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(node));
        return this.aliasedFunctions.contains(node);
    }

    public boolean isExposedToCallOrApply(Node node) {
        Preconditions.checkNotNull(this.functionsExposedToCallOrApply);
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(node));
        return this.functionsExposedToCallOrApply.contains(node);
    }

    public void analyze(SimpleDefinitionFinder simpleDefinitionFinder) {
        Preconditions.checkState((this.aliasedFunctions == null ? 1 : 0) != 0);
        this.aliasedFunctions = Sets.newHashSet();
        this.functionsExposedToCallOrApply = Sets.newHashSet();
        for (DefinitionSite definitionSite : simpleDefinitionFinder.getDefinitionSites()) {
            Node node;
            DefinitionsRemover.Definition definition = definitionSite.definition;
            if (definition.isExtern() || (node = definition.getRValue()) == null || !NodeUtil.isFunction(node)) continue;
            for (UseSite useSite : simpleDefinitionFinder.getUseSites(definition)) {
                this.updateFunctionForUse(node, useSite.node);
            }
        }
    }

    private void updateFunctionForUse(Node node, Node node2) {
        Node node3 = node2.getParent();
        int n = node3.getType();
        if (n != 37 && n != 30 || node3.getFirstChild() != node2) {
            if (NodeUtil.isGet(node3)) {
                Node node4;
                if (NodeUtil.isGetProp(node3) && (NodeUtil.isFunctionObjectApply(node4 = node3.getParent()) || NodeUtil.isFunctionObjectCall(node4))) {
                    this.functionsExposedToCallOrApply.add(node);
                }
            } else {
                this.aliasedFunctions.add(node);
            }
        }
    }
}

