/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ant;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.ant.AntErrorManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;

public final class CompileTask
extends Task {
    private WarningLevel warningLevel = WarningLevel.DEFAULT;
    private boolean debugOptions = false;
    private String encoding = "UTF-8";
    private String outputEncoding = "UTF-8";
    private CompilationLevel compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
    private boolean customExternsOnly = false;
    private boolean manageDependencies = false;
    private boolean prettyPrint = false;
    private boolean printInputDelimiter = false;
    private boolean generateExports = false;
    private File outputFile;
    private final List<FileList> externFileLists = Lists.newLinkedList();
    private final List<FileList> sourceFileLists = Lists.newLinkedList();

    public void setWarning(String string) {
        if ("default".equalsIgnoreCase(string)) {
            this.warningLevel = WarningLevel.DEFAULT;
        } else if ("quiet".equalsIgnoreCase(string)) {
            this.warningLevel = WarningLevel.QUIET;
        } else if ("verbose".equalsIgnoreCase(string)) {
            this.warningLevel = WarningLevel.VERBOSE;
        } else {
            throw new BuildException("Unrecognized 'warning' option value (" + string + ")");
        }
    }

    public void setDebug(boolean bl) {
        this.debugOptions = bl;
    }

    public void setCompilationLevel(String string) {
        if ("simple".equalsIgnoreCase(string)) {
            this.compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        } else if ("advanced".equalsIgnoreCase(string)) {
            this.compilationLevel = CompilationLevel.ADVANCED_OPTIMIZATIONS;
        } else if ("whitespace".equalsIgnoreCase(string)) {
            this.compilationLevel = CompilationLevel.WHITESPACE_ONLY;
        } else {
            throw new BuildException("Unrecognized 'compilation' option value (" + string + ")");
        }
    }

    public void setManageDependencies(boolean bl) {
        this.manageDependencies = bl;
    }

    public void setCustomExternsOnly(boolean bl) {
        this.customExternsOnly = bl;
    }

    public void setOutput(File file) {
        this.outputFile = file;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    public void setPrettyPrint(boolean bl) {
        this.prettyPrint = bl;
    }

    public void setPrintInputDelimiter(boolean bl) {
        this.printInputDelimiter = bl;
    }

    public void setGenerateExports(boolean bl) {
        this.generateExports = bl;
    }

    public void addExterns(FileList fileList) {
        this.externFileLists.add(fileList);
    }

    public void addSources(FileList fileList) {
        this.sourceFileLists.add(fileList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (this.outputFile == null) {
            throw new BuildException("outputFile attribute must be set");
        }
        Compiler.setLoggingLevel(Level.OFF);
        CompilerOptions compilerOptions = this.createCompilerOptions();
        Compiler compiler = this.createCompiler(compilerOptions);
        JSSourceFile[] jSSourceFileArray = this.findExternFiles();
        JSSourceFile[] jSSourceFileArray2 = this.findSourceFiles();
        if (this.isStale()) {
            this.log("Compiling " + jSSourceFileArray2.length + " file(s) with " + jSSourceFileArray.length + " extern(s)");
            Result result = compiler.compile(jSSourceFileArray, jSSourceFileArray2, compilerOptions);
            if (!result.success) throw new BuildException("Compilation failed.");
            this.writeResult(compiler.toSource());
            return;
        } else {
            this.log("None of the files changed. Compilation skipped.");
        }
    }

    private CompilerOptions createCompilerOptions() {
        CompilerOptions compilerOptions = new CompilerOptions();
        this.compilationLevel.setOptionsForCompilationLevel(compilerOptions);
        if (this.debugOptions) {
            this.compilationLevel.setDebugOptionsForCompilationLevel(compilerOptions);
        }
        compilerOptions.prettyPrint = this.prettyPrint;
        compilerOptions.printInputDelimiter = this.printInputDelimiter;
        compilerOptions.generateExports = this.generateExports;
        this.warningLevel.setOptionsForWarningLevel(compilerOptions);
        compilerOptions.setManageClosureDependencies(this.manageDependencies);
        return compilerOptions;
    }

    private Compiler createCompiler(CompilerOptions compilerOptions) {
        Compiler compiler = new Compiler();
        MessageFormatter messageFormatter = compilerOptions.errorFormat.toFormatter(compiler, false);
        AntErrorManager antErrorManager = new AntErrorManager(messageFormatter, this);
        compiler.setErrorManager(antErrorManager);
        return compiler;
    }

    private JSSourceFile[] findExternFiles() {
        LinkedList linkedList = Lists.newLinkedList();
        if (!this.customExternsOnly) {
            linkedList.addAll(this.getDefaultExterns());
        }
        for (FileList fileList : this.externFileLists) {
            linkedList.addAll(this.findJavaScriptFiles(fileList));
        }
        return linkedList.toArray(new JSSourceFile[linkedList.size()]);
    }

    private JSSourceFile[] findSourceFiles() {
        LinkedList linkedList = Lists.newLinkedList();
        for (FileList fileList : this.sourceFileLists) {
            linkedList.addAll(this.findJavaScriptFiles(fileList));
        }
        return linkedList.toArray(new JSSourceFile[linkedList.size()]);
    }

    private List<JSSourceFile> findJavaScriptFiles(FileList fileList) {
        LinkedList linkedList = Lists.newLinkedList();
        File file = fileList.getDir(this.getProject());
        for (String string : fileList.getFiles(this.getProject())) {
            linkedList.add(JSSourceFile.fromFile(new File(file, string), Charset.forName(this.encoding)));
        }
        return linkedList;
    }

    private List<JSSourceFile> getDefaultExterns() {
        try {
            return CommandLineRunner.getDefaultExterns();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    private void writeResult(String string) {
        if (this.outputFile.getParentFile().mkdirs()) {
            this.log("Created missing parent directory " + this.outputFile.getParentFile(), 4);
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), this.outputEncoding);
            outputStreamWriter.append(string);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        this.log("Compiled javascript written to " + this.outputFile.getAbsolutePath(), 4);
    }

    private boolean isStale() {
        long l = this.outputFile.lastModified();
        long l2 = this.getLastModifiedTime(this.sourceFileLists);
        long l3 = this.getLastModifiedTime(this.externFileLists);
        return l <= l2 || l <= l3;
    }

    private long getLastModifiedTime(List<FileList> list) {
        long l = 0L;
        for (FileList fileList : list) {
            for (String string : fileList.getFiles(this.getProject())) {
                File file = fileList.getDir(this.getProject());
                File file2 = new File(file, string);
                long l2 = file2.lastModified();
                if (l2 == 0L) {
                    l2 = new Date().getTime();
                }
                l = Math.max(l2, l);
            }
        }
        return l;
    }
}

