/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.mozilla.rhino.CompilerEnvirons;
import com.google.javascript.jscomp.mozilla.rhino.Context;
import com.google.javascript.jscomp.mozilla.rhino.ErrorReporter;
import com.google.javascript.jscomp.mozilla.rhino.EvaluatorException;
import com.google.javascript.jscomp.mozilla.rhino.Parser;
import com.google.javascript.jscomp.mozilla.rhino.ast.AstRoot;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.IRFactory;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;

public class ParserRunner {
    private static final String configResource = "com.google.javascript.jscomp.parsing.ParserConfig";
    private static Set<String> annotationNames = null;
    private static Set<String> suppressionNames = null;

    private ParserRunner() {
    }

    @Deprecated
    public static Config createConfig(boolean bl) {
        return ParserRunner.createConfig(bl, Config.LanguageMode.ECMASCRIPT3, false);
    }

    public static Config createConfig(boolean bl, Config.LanguageMode languageMode, boolean bl2) {
        ParserRunner.initResourceConfig();
        return new Config(annotationNames, suppressionNames, bl, languageMode, bl2);
    }

    private static synchronized void initResourceConfig() {
        if (annotationNames != null) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(configResource);
        annotationNames = ParserRunner.extractList(resourceBundle.getString("jsdoc.annotations"));
        suppressionNames = ParserRunner.extractList(resourceBundle.getString("jsdoc.suppressions"));
    }

    private static Set<String> extractList(String string) {
        String[] stringArray = string.split(",");
        HashSet hashSet = Sets.newHashSet();
        for (String string2 : stringArray) {
            hashSet.add(string2.trim());
        }
        return ImmutableSet.copyOf((Collection)hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node parse(String string, String string2, Config config, ErrorReporter errorReporter, Logger logger) throws IOException {
        Context context = Context.enter();
        context.setErrorReporter(errorReporter);
        context.setLanguageVersion(150);
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.initFromContext(context);
        compilerEnvirons.setRecordingComments(true);
        compilerEnvirons.setRecordingLocalJsDocComments(true);
        compilerEnvirons.setWarnTrailingComma(config.languageMode == Config.LanguageMode.ECMASCRIPT3);
        if (config.isIdeMode || config.languageMode != Config.LanguageMode.ECMASCRIPT3) {
            compilerEnvirons.setReservedKeywordAsIdentifier(true);
            compilerEnvirons.setAllowKeywordAsObjectPropertyName(true);
        }
        if (config.isIdeMode) {
            compilerEnvirons.setAllowMemberExprAsFunctionName(true);
        }
        Parser parser = new Parser(compilerEnvirons, errorReporter);
        AstRoot astRoot = null;
        try {
            astRoot = parser.parse(string2, string, 1);
        }
        catch (EvaluatorException evaluatorException) {
            logger.info("Error parsing " + string + ": " + evaluatorException.getMessage());
        }
        finally {
            Context.exit();
        }
        Node node = null;
        if (astRoot != null) {
            node = IRFactory.transformTree(astRoot, string2, config, errorReporter);
            node.setIsSyntheticBlock(true);
        }
        return node;
    }
}

