/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.Visitor;

public final class NullType
extends ValueType {
    private static final long serialVersionUID = 1L;

    NullType(JSTypeRegistry jSTypeRegistry) {
        super(jSTypeRegistry);
    }

    @Override
    public boolean isNullType() {
        return true;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        return this.registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        TernaryValue ternaryValue = super.testForEquality(jSType);
        if (ternaryValue != null) {
            return ternaryValue;
        }
        if (jSType.isNullType() || jSType.isVoidType()) {
            return TernaryValue.TRUE;
        }
        if (jSType.isUnknownType() || jSType.isNullable()) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return "null";
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.FALSE;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseNullType();
    }
}

