/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Links;
import com.paypal.api.payments.PayoutBatch;
import com.paypal.api.payments.PayoutItem;
import com.paypal.api.payments.PayoutSenderBatchHeader;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Payout
extends PayPalResource {
    private PayoutSenderBatchHeader senderBatchHeader;
    private List<PayoutItem> items;
    private List<Links> links;

    public Payout() {
    }

    public Payout(PayoutSenderBatchHeader senderBatchHeader, List<PayoutItem> items) {
        this.senderBatchHeader = senderBatchHeader;
        this.items = items;
    }

    public Payout setSenderBatchHeader(PayoutSenderBatchHeader senderBatchHeader) {
        this.senderBatchHeader = senderBatchHeader;
        return this;
    }

    public PayoutSenderBatchHeader getSenderBatchHeader() {
        return this.senderBatchHeader;
    }

    public Payout setItems(List<PayoutItem> items) {
        this.items = items;
        return this;
    }

    public List<PayoutItem> getItems() {
        return this.items;
    }

    public Payout setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public PayoutBatch createSynchronous(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("sync_mode", "true");
        return this.create(apiContext, parameters);
    }

    public PayoutBatch createSynchronous(APIContext apiContext) throws PayPalRESTException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("sync_mode", "true");
        return this.create(apiContext, parameters);
    }

    public PayoutBatch create(String accessToken, Map<String, String> parameters) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext, parameters);
    }

    public PayoutBatch create(APIContext apiContext, Map<String, String> parameters) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        Object[] parametersObj = new Object[]{parameters};
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        String pattern = "v1/payments/payouts?sync_mode={0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parametersObj);
        String payLoad = this.toJSON();
        return Payout.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, PayoutBatch.class);
    }

    public static PayoutBatch get(String accessToken, String payoutBatchId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Payout.get(apiContext, payoutBatchId);
    }

    public static PayoutBatch get(APIContext apiContext, String payoutBatchId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (payoutBatchId == null) {
            throw new IllegalArgumentException("payoutBatchId cannot be null");
        }
        Object[] parameters = new Object[]{payoutBatchId};
        String pattern = "v1/payments/payouts/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Payout.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, PayoutBatch.class);
    }
}

