/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Currency;
import com.paypal.api.payments.PayoutItemDetails;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.util.HashMap;

public class PayoutItem
extends PayPalResource {
    private String recipientType;
    private Currency amount;
    private String note;
    private String receiver;
    private String senderItemId;

    public PayoutItem() {
    }

    public PayoutItem(Currency amount, String receiver) {
        this.amount = amount;
        this.receiver = receiver;
    }

    public PayoutItem setRecipientType(String recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    public String getRecipientType() {
        return this.recipientType;
    }

    public PayoutItem setAmount(Currency amount) {
        this.amount = amount;
        return this;
    }

    public Currency getAmount() {
        return this.amount;
    }

    public PayoutItem setNote(String note) {
        this.note = note;
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public PayoutItem setReceiver(String receiver) {
        this.receiver = receiver;
        return this;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public PayoutItem setSenderItemId(String senderItemId) {
        this.senderItemId = senderItemId;
        return this;
    }

    public String getSenderItemId() {
        return this.senderItemId;
    }

    public static PayoutItemDetails get(String accessToken, String payoutItemId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return PayoutItem.get(apiContext, payoutItemId);
    }

    public static PayoutItemDetails get(APIContext apiContext, String payoutItemId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (payoutItemId == null) {
            throw new IllegalArgumentException("payoutItemId cannot be null");
        }
        Object[] parameters = new Object[]{payoutItemId};
        String pattern = "v1/payments/payouts-item/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayoutItem.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, PayoutItemDetails.class);
    }

    public static PayoutItemDetails cancel(String accessToken, String payoutItemId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return PayoutItem.cancel(apiContext, payoutItemId);
    }

    public static PayoutItemDetails cancel(APIContext apiContext, String payoutItemId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (payoutItemId == null) {
            throw new IllegalArgumentException("payoutItemId cannot be null");
        }
        Object[] parameters = new Object[]{payoutItemId};
        String pattern = "v1/payments/payouts-item/{0}/cancel";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayoutItem.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, PayoutItemDetails.class);
    }
}

