/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base;

import com.paypal.base.credential.CertificateCredential;
import com.paypal.base.credential.ICredential;
import com.paypal.base.credential.SignatureCredential;
import com.paypal.base.credential.SubjectAuthorization;
import com.paypal.base.exception.InvalidCredentialException;
import com.paypal.base.exception.MissingCredentialException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CredentialManager {
    private Map<String, String> configurationMap = null;

    public CredentialManager(Map<String, String> configurationMap) {
        if (configurationMap == null) {
            throw new IllegalArgumentException("ConfigurationMap cannot be null");
        }
        this.configurationMap = configurationMap;
    }

    public ICredential getCredentialObject(String userId) throws MissingCredentialException, InvalidCredentialException {
        ICredential credential = null;
        if (this.getAccounts(this.configurationMap).size() == 0) {
            throw new MissingCredentialException("No API accounts have been configured in application properties");
        }
        String prefix = "acct";
        Map<String, String> credMap = this.getValuesByCategory(this.configurationMap, prefix);
        if (userId != null && userId.trim().length() != 0) {
            for (Map.Entry<String, String> entry : credMap.entrySet()) {
                if (!entry.getKey().endsWith(".UserName") || !entry.getValue().equalsIgnoreCase(userId)) continue;
                String acctKey = entry.getKey().substring(0, entry.getKey().indexOf(46));
                credential = this.returnCredential(credMap, acctKey);
            }
            if (credential == null) {
                throw new MissingCredentialException("Account for the username does not exists in the properties file");
            }
        } else {
            int index = 1;
            String userName = credMap.get(prefix + index + ".UserName");
            if (userName != null && userName.trim().length() != 0) {
                credential = this.returnCredential(credMap, prefix + index);
            } else {
                throw new MissingCredentialException("Associate valid account for index 1");
            }
        }
        return credential;
    }

    private Set<String> getAccounts(Map<String, String> configurationMap) {
        String key = "";
        HashSet<String> set = new HashSet<String>();
        for (String obj : configurationMap.keySet()) {
            key = obj;
            if (!key.contains("acct")) continue;
            int pos = key.indexOf(46);
            String acct = key.substring(0, pos);
            set.add(acct);
        }
        return set;
    }

    private Map<String, String> getValuesByCategory(Map<String, String> configurationMap, String category) {
        String key = "";
        HashMap<String, String> map = new HashMap<String, String>();
        for (String obj : configurationMap.keySet()) {
            key = obj;
            if (!key.contains(category)) continue;
            map.put(key, configurationMap.get(key));
        }
        return map;
    }

    private ICredential returnCredential(Map<String, String> credMap, String acctKey) throws InvalidCredentialException {
        ICredential credential = null;
        String userName = credMap.get(acctKey + ".UserName");
        String password = credMap.get(acctKey + ".Password");
        String appId = credMap.get(acctKey + ".AppId");
        String subject = credMap.get(acctKey + ".Subject");
        if (credMap.get(acctKey + ".Signature") != null) {
            String signature = credMap.get(acctKey + ".Signature");
            credential = new SignatureCredential(userName, password, signature);
            credential.setApplicationId(appId);
            if (subject != null && subject.trim().length() > 0) {
                SubjectAuthorization thirdPartyAuthorization = new SubjectAuthorization(subject);
                credential.setThirdPartyAuthorization(thirdPartyAuthorization);
            }
        } else if (credMap.get(acctKey + ".CertPath") != null) {
            String certPath = credMap.get(acctKey + ".CertPath");
            String certKey = credMap.get(acctKey + ".CertKey");
            credential = new CertificateCredential(userName, password, certPath, certKey);
            ((CertificateCredential)credential).setApplicationId(appId);
            if (subject != null && subject.trim().length() > 0) {
                SubjectAuthorization thirdPartyAuthorization = new SubjectAuthorization(subject);
                ((CertificateCredential)credential).setThirdPartyAuthorization(thirdPartyAuthorization);
            }
        } else {
            throw new InvalidCredentialException("The account does not have a valid credential type(signature/certificate)");
        }
        return credential;
    }
}

