/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.rest;

import com.paypal.base.BaseAPIContext;
import com.paypal.base.SDKVersion;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIContext
extends BaseAPIContext {
    private String accessToken;
    private String requestId;
    private boolean maskRequestId;
    private SDKVersion sdkVersion;

    public APIContext() {
    }

    public APIContext(String accessToken) {
        if (accessToken == null || accessToken.length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null");
        }
        this.accessToken = accessToken;
    }

    public APIContext(String accessToken, String requestId) {
        this(accessToken);
        if (requestId == null || requestId.length() <= 0) {
            throw new IllegalArgumentException("RequestId cannot be null");
        }
        this.requestId = requestId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRequestId() {
        String reqId = null;
        if (!this.maskRequestId) {
            if (this.requestId == null || this.requestId.length() <= 0) {
                this.requestId = UUID.randomUUID().toString();
            }
            reqId = this.requestId;
        }
        return reqId;
    }

    public void setMaskRequestId(boolean maskRequestId) {
        this.maskRequestId = maskRequestId;
    }

    public SDKVersion getSdkVersion() {
        return this.sdkVersion;
    }

    public void setSdkVersion(SDKVersion sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public Map<String, String> getHeadersMap() {
        return super.getHTTPHeaders();
    }

    public void setHeadersMap(Map<String, String> headersMap) {
        super.setHTTPHeaders(headersMap);
    }
}

