/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.ssh.jce;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.adamcin.httpsig.api.Base64;
import net.adamcin.httpsig.api.DefaultKeychain;
import net.adamcin.httpsig.api.Key;
import net.adamcin.httpsig.api.Keychain;
import net.adamcin.httpsig.ssh.jce.KeyFormat;
import net.adamcin.httpsig.ssh.jce.SSHKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthorizedKeys {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizedKeys.class);
    private static final Pattern AUTHORIZED_KEY_PATTERN = Pattern.compile("^([^\\s]+)\\s+([^\\s]+)(\\s+([^\\s].*)|$)");
    private static final String DEFAULT_PATH = ".ssh/authorized_keys";
    private static final int GROUP_FORMAT = 1;
    private static final int GROUP_KEY = 2;
    private static final int GROUP_COMMENT = 4;
    private static final Charset ASCII = Charset.forName("US-ASCII");

    public static Keychain defaultKeychain() throws IOException {
        return AuthorizedKeys.newKeychain(new File(new File(System.getProperty("user.home", "/")), DEFAULT_PATH));
    }

    public static Keychain newKeychain(File authorizedKeysFile) throws IOException {
        DefaultKeychain identities = new DefaultKeychain();
        for (AuthorizedKey authorizedKey : AuthorizedKeys.parseAuthorizedKeys(authorizedKeysFile)) {
            identities.add(AuthorizedKeys.getAuthorizedKeyIdentity(authorizedKey));
        }
        return identities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<AuthorizedKey> parseAuthorizedKeys(File authorizedKeys) throws IOException {
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(authorizedKeys), ASCII);
            List<AuthorizedKey> list = AuthorizedKeys.parseAuthorizedKeys(reader);
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    static List<AuthorizedKey> parseAuthorizedKeys(Reader reader) throws IOException {
        String line;
        ArrayList<AuthorizedKey> authorizedKeys = new ArrayList<AuthorizedKey>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            AuthorizedKey authorizedKey = AuthorizedKeys.parseAuthorizedKey(line);
            if (authorizedKey == null) continue;
            authorizedKeys.add(authorizedKey);
        }
        return Collections.unmodifiableList(authorizedKeys);
    }

    static AuthorizedKey parseAuthorizedKey(String authorizedKeyString) {
        Matcher matcher;
        if (authorizedKeyString != null && (matcher = AUTHORIZED_KEY_PATTERN.matcher(authorizedKeyString)).find()) {
            String format = matcher.group(1);
            String encodedKey = matcher.group(2);
            String comment = matcher.group(4);
            return new AuthorizedKey(format, encodedKey, comment);
        }
        return null;
    }

    static Key getAuthorizedKeyIdentity(AuthorizedKey authorizedKey) {
        if (authorizedKey != null) {
            byte[] keyBlob = Base64.fromBase64String((String)authorizedKey.getEncodedKey());
            return AuthorizedKeys.readPublicIdentity(keyBlob);
        }
        return null;
    }

    static PublicPair readPublicPair(byte[] keyBlob) {
        String type;
        ByteArrayInputStream is = new ByteArrayInputStream(keyBlob);
        DataInputStream dis = new DataInputStream(is);
        try {
            byte[] b_type = new byte[dis.readInt()];
            int r_type = dis.read(b_type);
            type = new String(b_type, ASCII);
        }
        catch (IOException e) {
            throw new IllegalStateException("how did an IOException get thrown from a byte array input stream?", e);
        }
        KeyFormat keyFormat = KeyFormat.forIdentifier(type);
        KeySpec spec = null;
        try {
            switch (keyFormat) {
                case SSH_RSA: {
                    byte[] b_e = new byte[dis.readInt()];
                    int r_e = dis.read(b_e);
                    BigInteger e = new BigInteger(b_e);
                    byte[] b_m = new byte[dis.readInt()];
                    int r_m = dis.read(b_m);
                    BigInteger m = new BigInteger(b_m);
                    spec = new RSAPublicKeySpec(m, e);
                    break;
                }
                case SSH_DSS: {
                    byte[] b_p = new byte[dis.readInt()];
                    int r_p = dis.read(b_p);
                    BigInteger p = new BigInteger(b_p);
                    byte[] b_q = new byte[dis.readInt()];
                    int r_q = dis.read(b_q);
                    BigInteger q = new BigInteger(b_q);
                    byte[] b_g = new byte[dis.readInt()];
                    int r_g = dis.read(b_g);
                    BigInteger g = new BigInteger(b_g);
                    byte[] b_y = new byte[dis.readInt()];
                    int r_y = dis.read(b_y);
                    BigInteger y = new BigInteger(b_y);
                    spec = new DSAPublicKeySpec(y, p, q, g);
                    break;
                }
                case UNKOWN: {
                    throw new IllegalArgumentException("unknown key format: " + type);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("how did an IOException get thrown from a byte array input stream?", e);
        }
        return new PublicPair(keyFormat, spec);
    }

    static Key createPublicIdentity(PublicPair pair) {
        KeyFactory keyFactory = pair.getFormat().getKeyFactory();
        assert (keyFactory != null);
        try {
            PublicKey publicKey = keyFactory.generatePublic(pair.getSpec());
            return new SSHKey(pair.getFormat(), publicKey, null);
        }
        catch (InvalidKeySpecException e) {
            LOGGER.error("this exception should not have been thrown.", (Throwable)e);
            return null;
        }
    }

    static Key readPublicIdentity(byte[] keyBlob) {
        PublicPair pair = AuthorizedKeys.readPublicPair(keyBlob);
        return AuthorizedKeys.createPublicIdentity(pair);
    }

    static final class AuthorizedKey {
        private final String format;
        private final String encodedKey;
        private final String comment;

        AuthorizedKey(String format, String encodedKey, String comment) {
            this.format = format;
            this.encodedKey = encodedKey;
            this.comment = comment;
        }

        public String getFormat() {
            return this.format;
        }

        public String getEncodedKey() {
            return this.encodedKey;
        }

        public String getComment() {
            return this.comment;
        }

        public String toString() {
            return String.format("%s %s %s", this.format, this.encodedKey, this.comment);
        }
    }

    static final class PublicPair {
        private final KeyFormat format;
        private final KeySpec spec;

        PublicPair(KeyFormat format, KeySpec spec) {
            this.format = format;
            this.spec = spec;
        }

        public KeyFormat getFormat() {
            return this.format;
        }

        public KeySpec getSpec() {
            return this.spec;
        }
    }
}

