/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.ssh.jce;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.ssh.jce.FingerprintGenerator;
import net.adamcin.httpsig.ssh.jce.SSHDSSSignature;
import net.adamcin.httpsig.ssh.jce.SSHRSASignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KeyFormat {
    SSH_DSS("ssh-dss", "DSA", FingerprintGenerator.DSA, Algorithm.SSH_DSS, Arrays.asList(Algorithm.SSH_DSS, Algorithm.DSA_SHA1)),
    SSH_RSA("ssh-rsa", "RSA", FingerprintGenerator.RSA, Algorithm.SSH_RSA, Arrays.asList(Algorithm.SSH_RSA, Algorithm.RSA_SHA1, Algorithm.RSA_SHA256, Algorithm.RSA_SHA512)),
    UNKOWN("_unknown_", "_unknown_", FingerprintGenerator.NOP, null, Collections.<Algorithm>emptyList());

    private static final Logger LOGGER;
    private final String identifier;
    private final String keyAlgorithm;
    private final Algorithm defaultSignature;
    private final List<Algorithm> signatureAlgorithms;
    private final FingerprintGenerator fingerprintGenerator;

    private KeyFormat(String identifier, String keyAlgorithm, FingerprintGenerator fingerprintGenerator, Algorithm defaultSignature, List<Algorithm> signatureAlgorithms) {
        this.identifier = identifier;
        this.keyAlgorithm = keyAlgorithm;
        this.fingerprintGenerator = fingerprintGenerator;
        this.defaultSignature = defaultSignature;
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public KeyFactory getKeyFactory() {
        try {
            return KeyFactory.getInstance(this.getKeyAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public List<Algorithm> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    public String getFingerprint(PublicKey publicKey) {
        return this.fingerprintGenerator.getFingerprint(publicKey);
    }

    public Signature getSignatureInstance(Algorithm algorithm) {
        return KeyFormat.getSignatureInstanceInternal(algorithm != null ? algorithm : this.defaultSignature);
    }

    private static Signature getSignatureInstanceInternal(Algorithm algorithm) {
        if (algorithm != null) {
            try {
                switch (algorithm) {
                    case SSH_DSS: {
                        return new SSHDSSSignature();
                    }
                    case SSH_RSA: {
                        return new SSHRSASignature();
                    }
                    case RSA_SHA1: {
                        return Signature.getInstance("SHA1withRSA");
                    }
                    case RSA_SHA256: {
                        return Signature.getInstance("SHA256withRSA");
                    }
                    case RSA_SHA512: {
                        return Signature.getInstance("SHA512withRSA");
                    }
                    case DSA_SHA1: {
                        return Signature.getInstance("SHA1withDSA");
                    }
                }
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error("[getSignatureInstance] failed to get signature instance.", (Throwable)e);
            }
        }
        return null;
    }

    public static KeyFormat forIdentifier(String identifier) {
        for (KeyFormat format : KeyFormat.values()) {
            if (!format.getIdentifier().equals(identifier)) continue;
            return format;
        }
        return UNKOWN;
    }

    static {
        LOGGER = LoggerFactory.getLogger(KeyFormat.class);
    }
}

