/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Components;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationJavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationTagProviderManager;
import org.apache.felix.scrplugin.tags.cl.ClassLoaderJavaClassDescription;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaClassDescription;
import org.apache.felix.scrplugin.xml.ComponentDescriptorIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaClassDescriptorManager {
    protected final Log log;
    private final ClassLoader classloader;
    private final Map<String, JavaClassDescription> javaClassDescriptions = new HashMap<String, JavaClassDescription>();
    private final AnnotationTagProviderManager annotationTagProviderManager;
    private final boolean parseJavadocs;
    private final boolean processAnnotations;
    private JavaSource[] sources;
    private Map<String, Component> componentDescriptions;
    private boolean doingHasScrPluginAnnotationCheck = false;

    public JavaClassDescriptorManager(Log log, ClassLoader classLoader, String[] annotationTagProviders, boolean parseJavadocs, boolean processAnnotations) throws SCRDescriptorFailureException {
        this.processAnnotations = processAnnotations;
        this.parseJavadocs = parseJavadocs;
        this.log = log;
        this.annotationTagProviderManager = new AnnotationTagProviderManager(annotationTagProviders, classLoader);
        this.classloader = classLoader;
    }

    protected JavaSource[] getSources() throws SCRDescriptorException {
        if (this.sources == null) {
            this.log.debug("Setting up QDox");
            JavaDocBuilder builder = new JavaDocBuilder();
            builder.getClassLibrary().addClassLoader(this.getClassLoader());
            Iterator<File> i = this.getSourceFiles();
            while (i.hasNext()) {
                File file = i.next();
                this.log.debug("Adding source file " + file);
                try {
                    builder.addSource(file);
                }
                catch (IOException e) {
                    throw new SCRDescriptorException("Unable to add source file", file.toString(), 0, e);
                }
            }
            this.sources = builder.getSources();
        }
        return this.sources;
    }

    protected Iterator<File> getSourceFiles() {
        return Collections.emptyList().iterator();
    }

    protected Map<String, Component> getComponentDescriptors() throws SCRDescriptorException {
        if (this.componentDescriptions == null) {
            ArrayList<Component> components = new ArrayList<Component>();
            List<File> dependencies = this.getDependencies();
            for (File artifact : dependencies) {
                this.log.debug("Trying to get manifest from artifact " + artifact);
                try {
                    Manifest manifest = this.getManifest(artifact);
                    if (manifest != null) {
                        if (manifest.getMainAttributes().getValue("Service-Component") != null) {
                            String serviceComponent = manifest.getMainAttributes().getValue("Service-Component");
                            this.log.debug("Found Service-Component: " + serviceComponent + " in artifact " + artifact);
                            StringTokenizer st = new StringTokenizer(serviceComponent, ",");
                            while (st.hasMoreTokens()) {
                                Components c;
                                String entry = st.nextToken().trim();
                                if (entry.length() <= 0 || (c = this.readServiceComponentDescriptor(artifact, entry)) == null) continue;
                                components.addAll(c.getComponents());
                            }
                        } else {
                            this.log.debug("Artifact has no service component entry in manifest " + artifact);
                        }
                    } else {
                        this.log.debug("Unable to get manifest from artifact " + artifact);
                    }
                }
                catch (IOException ioe) {
                    throw new SCRDescriptorException("Unable to get manifest from artifact", artifact.toString(), 0, ioe);
                }
                this.log.debug("Trying to get scrinfo from artifact " + artifact);
                InputStream scrInfoFile = null;
                try {
                    scrInfoFile = this.getFile(artifact, "OSGI-INF/scr-plugin/scrinfo.xml");
                    if (scrInfoFile != null) {
                        components.addAll(this.parseServiceComponentDescriptor(scrInfoFile).getComponents());
                    } else {
                        this.log.debug("Artifact has no scrinfo file (it's optional): " + artifact);
                    }
                }
                catch (IOException ioe) {
                    throw new SCRDescriptorException("Unable to get scrinfo from artifact", artifact.toString(), 0, ioe);
                }
                finally {
                    if (scrInfoFile != null) {
                        try {
                            scrInfoFile.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                this.componentDescriptions = new HashMap<String, Component>();
                for (Component component : components) {
                    this.componentDescriptions.put(component.getImplementation().getClassame(), component);
                }
            }
        }
        return this.componentDescriptions;
    }

    protected List<File> getDependencies() {
        return Collections.emptyList();
    }

    public abstract String getOutputDirectory();

    public Log getLog() {
        return this.log;
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public AnnotationTagProviderManager getAnnotationTagProviderManager() {
        return this.annotationTagProviderManager;
    }

    public boolean isParseJavadocs() {
        return this.parseJavadocs;
    }

    public boolean isProcessAnnotations() {
        return this.processAnnotations;
    }

    protected Components parseServiceComponentDescriptor(InputStream file) throws SCRDescriptorException {
        return ComponentDescriptorIO.read(file);
    }

    public JavaClassDescription[] getSourceDescriptions() throws SCRDescriptorException {
        JavaClass[] javaClasses = this.getJavaClassesFromSources();
        JavaClassDescription[] descs = new JavaClassDescription[javaClasses.length];
        for (int i = 0; i < javaClasses.length; ++i) {
            descs[i] = this.getJavaClassDescription(javaClasses[i].getFullyQualifiedName());
        }
        return descs;
    }

    private boolean hasScrPluginAnnotation(Class<?> clazz, JavaClass javaClass) {
        this.doingHasScrPluginAnnotationCheck = true;
        boolean result = this.getAnnotationTagProviderManager().hasScrPluginAnnotation(javaClass, new AnnotationJavaClassDescription(clazz, javaClass, this));
        this.doingHasScrPluginAnnotationCheck = false;
        return result;
    }

    public JavaClassDescription getJavaClassDescription(String className) throws SCRDescriptorException {
        JavaClassDescription result = this.javaClassDescriptions.get(className);
        if (result == null) {
            this.log.debug("Searching description for: " + className);
            int index = 0;
            JavaClass[] javaClasses = this.getJavaClassesFromSources();
            while (result == null && index < javaClasses.length) {
                JavaClass javaClass = javaClasses[index];
                if (javaClass.getFullyQualifiedName().equals(className)) {
                    try {
                        Class<?> clazz = this.classloader.loadClass(className);
                        if (this.processAnnotations && !this.doingHasScrPluginAnnotationCheck && this.hasScrPluginAnnotation(clazz, javaClass)) {
                            this.log.debug("Found java annotation description for: " + className);
                            result = new AnnotationJavaClassDescription(clazz, javaClass, this);
                            continue;
                        }
                        if (!this.parseJavadocs) continue;
                        this.log.debug("Found qdox description for: " + className);
                        result = new QDoxJavaClassDescription(clazz, javaClass, this);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new SCRDescriptorException("Unable to load class", className, 0);
                    }
                }
                ++index;
            }
            if (result == null) {
                try {
                    this.log.debug("Generating classloader description for: " + className);
                    result = new ClassLoaderJavaClassDescription(this.classloader.loadClass(className), this.getComponentDescriptors().get(className), this);
                }
                catch (ClassNotFoundException e) {
                    throw new SCRDescriptorException("Unable to load class", className, 0);
                }
            }
            if (!this.doingHasScrPluginAnnotationCheck) {
                this.javaClassDescriptions.put(className, result);
            }
        }
        return result;
    }

    private JavaClass[] getJavaClassesFromSources() throws SCRDescriptorException {
        JavaSource[] sources = this.getSources();
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
        for (int i = 0; i < sources.length; ++i) {
            if (sources[i].getClasses() == null || sources[i].getClasses().length == 0) continue;
            for (int j = 0; j < sources[i].getClasses().length; ++j) {
                JavaClass clazz = sources[i].getClasses()[j];
                classes.add(clazz);
                for (int k = 0; k < clazz.getNestedClasses().length; ++k) {
                    JavaClass nestedClass = clazz.getNestedClasses()[k];
                    classes.add(nestedClass);
                }
            }
        }
        return classes.toArray(new JavaClass[classes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Components readServiceComponentDescriptor(File artifactFile, String entry) {
        this.log.debug("Reading " + entry + " from " + artifactFile);
        InputStream xml = null;
        try {
            xml = this.getFile(artifactFile, entry);
            if (xml == null) {
                throw new SCRDescriptorException("Entry " + entry + " not contained in JAR File ", artifactFile.toString(), 0);
            }
            Components components = this.parseServiceComponentDescriptor(xml);
            return components;
        }
        catch (IOException mee) {
            this.log.warn("Unable to read SCR descriptor file from JAR File " + artifactFile + " at " + entry);
            this.log.debug("Exception occurred during reading: " + mee.getMessage(), mee);
        }
        catch (SCRDescriptorException mee) {
            this.log.warn("Unable to read SCR descriptor file from JAR File " + artifactFile + " at " + entry);
            this.log.debug("Exception occurred during reading: " + mee.getMessage(), mee);
        }
        finally {
            if (xml != null) {
                try {
                    xml.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(File artifact) throws IOException {
        if (artifact.isDirectory()) {
            File dir = new File(artifact, "META-INF");
            if (!dir.exists() || !dir.isDirectory()) {
                return null;
            }
            File mf = new File(dir, "MANIFEST.MF");
            if (!mf.exists() || !mf.isFile()) {
                return null;
            }
            FileInputStream is = new FileInputStream(mf);
            try {
                Manifest manifest = new Manifest(is);
                return manifest;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ignore) {}
            }
        }
        JarFile file = null;
        try {
            file = new JarFile(artifact);
            Manifest manifest = file.getManifest();
            return manifest;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getFile(File artifactFile, String path) throws IOException {
        if (artifactFile.isDirectory()) {
            String filePath = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            File file = new File(artifactFile, filePath);
            if (file.exists() && file.isFile()) {
                return new FileInputStream(file);
            }
            return null;
        }
        JarFile file = null;
        try {
            file = new JarFile(artifactFile);
            JarEntry entry = file.getJarEntry(path);
            if (entry != null) {
                ArtifactFileInputStream stream = new ArtifactFileInputStream(file, entry);
                file = null;
                ArtifactFileInputStream artifactFileInputStream = stream;
                return artifactFileInputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static class ArtifactFileInputStream
    extends FilterInputStream {
        final JarFile jarFile;

        ArtifactFileInputStream(JarFile jarFile, JarEntry jarEntry) throws IOException {
            super(jarFile.getInputStream(jarEntry));
            this.jarFile = jarFile;
        }

        public void close() throws IOException {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jarFile.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

