/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.om;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.helper.IssueLog;
import org.apache.felix.scrplugin.om.AbstractObject;
import org.apache.felix.scrplugin.om.Implementation;
import org.apache.felix.scrplugin.om.Property;
import org.apache.felix.scrplugin.om.Reference;
import org.apache.felix.scrplugin.om.Service;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaMethod;
import org.apache.felix.scrplugin.tags.JavaTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
extends AbstractObject {
    protected String name;
    protected Boolean enabled;
    protected Boolean immediate;
    protected String factory;
    protected Implementation implementation;
    protected List<Property> properties = new ArrayList<Property>();
    protected Service service;
    protected List<Reference> references = new ArrayList<Reference>();
    protected boolean isAbstract;
    protected boolean isDs;
    protected String configurationPolicy;
    protected String activate;
    protected String deactivate;
    protected String modified;
    protected int specVersion;
    private static final String TYPE_COMPONENT_CONTEXT = "org.osgi.service.component.ComponentContext";
    private static final String TYPE_BUNDLE_CONTEXT = "org.osgi.framework.BundleContext";
    private static final String TYPE_MAP = "java.util.Map";
    private static final String TYPE_INT = "int";
    private static final String TYPE_INTEGER = "java.lang.Integer";

    public Component() {
        this(null);
    }

    public Component(JavaTag t) {
        super(t);
    }

    public int getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(int value) {
        if (this.specVersion < value) {
            this.specVersion = value;
        }
    }

    public JavaClassDescription getJavaClassDescription() {
        if (this.tag != null) {
            return this.tag.getJavaClassDescription();
        }
        return null;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(Boolean immediate) {
        this.immediate = immediate;
    }

    public Implementation getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Implementation implementation) {
        this.implementation = implementation;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    public void addReference(Reference ref) {
        this.references.add(ref);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isDs() {
        return this.isDs;
    }

    public void setDs(boolean isDs) {
        this.isDs = isDs;
    }

    public String getActivate() {
        return this.activate;
    }

    public void setDeactivate(String value) {
        this.deactivate = value;
    }

    public String getDeactivate() {
        return this.deactivate;
    }

    public void setActivate(String value) {
        this.activate = value;
    }

    public void setModified(String value) {
        this.modified = value;
    }

    public String getModified() {
        return this.modified;
    }

    public void validate(int specVersion, IssueLog iLog) throws SCRDescriptorException {
        String cp;
        int currentIssueCount = iLog.getNumberOfErrors();
        if (!this.isDs()) {
            return;
        }
        JavaClassDescription javaClass = this.tag.getJavaClassDescription();
        if (javaClass == null) {
            this.logError(iLog, "Tag not declared in a Java Class");
        } else {
            if (!this.isAbstract) {
                if (!javaClass.isPublic()) {
                    this.logError(iLog, "Class must be public: " + javaClass.getName());
                }
                if (javaClass.isAbstract() || javaClass.isInterface()) {
                    this.logError(iLog, "Class must be concrete class (not abstract or interface) : " + javaClass.getName());
                }
                if (iLog.getNumberOfErrors() == currentIssueCount) {
                    String activateName = this.activate == null ? "activate" : this.activate;
                    String deactivateName = this.deactivate == null ? "deactivate" : this.deactivate;
                    this.checkLifecycleMethod(specVersion, javaClass, activateName, true, iLog);
                    this.checkLifecycleMethod(specVersion, javaClass, deactivateName, false, iLog);
                    if (this.modified != null && specVersion >= 1) {
                        this.checkLifecycleMethod(specVersion, javaClass, this.modified, true, iLog);
                    }
                    boolean constructorFound = true;
                    JavaMethod[] methods = javaClass.getMethods();
                    for (int i = 0; methods != null && i < methods.length; ++i) {
                        if (!methods[i].isConstructor()) continue;
                        if (methods[i].isPublic() && (methods[i].getParameters() == null || methods[i].getParameters().length == 0)) {
                            constructorFound = true;
                            break;
                        }
                        constructorFound = false;
                    }
                    if (!constructorFound) {
                        this.logError(iLog, "Class must have public default constructor: " + javaClass.getName());
                    }
                    for (Property prop : this.getProperties()) {
                        prop.validate(specVersion, iLog);
                    }
                    boolean isServiceFactory = false;
                    if (this.getService() != null) {
                        if (this.getService().getInterfaces().size() == 0) {
                            this.logError(iLog, "Service interface information is missing!");
                        }
                        this.getService().validate(specVersion, iLog);
                        isServiceFactory = this.getService().isServicefactory();
                    }
                    if (isServiceFactory && this.isImmediate() != null && this.isImmediate().booleanValue() && this.getFactory() != null) {
                        this.logError(iLog, "Component must not be a ServiceFactory, if immediate and/or component factory: " + javaClass.getName());
                    }
                    if (this.isImmediate() != null && this.isImmediate().booleanValue() && this.getFactory() != null) {
                        this.logError(iLog, "Component must not be immediate if component factory: " + javaClass.getName());
                    }
                }
            }
            if (iLog.getNumberOfErrors() == currentIssueCount) {
                for (Reference ref : this.getReferences()) {
                    ref.validate(specVersion, this.isAbstract, iLog);
                }
            }
        }
        if (!(specVersion < 1 || (cp = this.getConfigurationPolicy()) == null || "ignore".equals(cp) || "require".equals(cp) || "optional".equals(cp))) {
            this.logError(iLog, "Component has an unknown value for configuration policy: " + cp);
        }
    }

    protected void checkLifecycleMethod(int specVersion, JavaClassDescription javaClass, String methodName, boolean isActivate, IssueLog iLog) throws SCRDescriptorException {
        JavaMethod method = javaClass.getMethodBySignature(methodName, new String[]{TYPE_COMPONENT_CONTEXT});
        if (method == null) {
            if (specVersion >= 1 && (method = javaClass.getMethodBySignature(methodName, new String[]{TYPE_BUNDLE_CONTEXT})) == null && (method = javaClass.getMethodBySignature(methodName, new String[]{TYPE_MAP})) == null) {
                if (!isActivate && (method = javaClass.getMethodBySignature(methodName, new String[]{TYPE_INT})) == null) {
                    method = javaClass.getMethodBySignature(methodName, new String[]{TYPE_INTEGER});
                }
                JavaMethod zeroArgMethod = null;
                JavaMethod found = method;
                JavaMethod[] methods = javaClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if (!methodName.equals(methods[i].getName())) continue;
                    if (methods[i].getParameters().length == 0) {
                        zeroArgMethod = methods[i];
                        continue;
                    }
                    if (methods[i].getParameters().length < 2) continue;
                    boolean valid = true;
                    for (int m = 0; m < methods[i].getParameters().length; ++m) {
                        String type = methods[i].getParameters()[m].getType();
                        if (type.equals(TYPE_BUNDLE_CONTEXT) || type.equals(TYPE_COMPONENT_CONTEXT) || type.equals(TYPE_MAP) || !isActivate && (type.equals(TYPE_INT) || type.equals(TYPE_INTEGER))) continue;
                        valid = false;
                    }
                    if (!valid) continue;
                    if (found == null) {
                        found = methods[i];
                        continue;
                    }
                    this.logWarn(iLog, "Lifecycle method " + methods[i].getName() + " occurs several times with different matching signature.");
                }
                method = found != null ? found : zeroArgMethod;
            }
            if (method == null) {
                JavaMethod[] methods = javaClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if (!methodName.equals(methods[i].getName())) continue;
                    if (methods[i].getParameters().length != 1) {
                        this.logWarn(iLog, "Lifecycle method " + methods[i].getName() + " has wrong number of arguments");
                        continue;
                    }
                    this.logWarn(iLog, "Lifecycle method " + methods[i].getName() + " has wrong argument " + methods[i].getParameters()[0].getType());
                }
            }
        }
        if (method != null && specVersion == 0) {
            if (method.isPublic()) {
                this.logWarn(iLog, "Lifecycle method " + method.getName() + " should be declared protected");
            } else if (!method.isProtected()) {
                this.logWarn(iLog, "Lifecycle method " + method.getName() + " has wrong qualifier, public or protected required");
            }
        }
    }

    public String getConfigurationPolicy() {
        return this.configurationPolicy;
    }

    public void setConfigurationPolicy(String value) {
        this.configurationPolicy = value;
    }

    public String toString() {
        return "Component " + this.name + " (" + "enabled=" + (this.enabled == null ? "<notset>" : this.enabled) + ", immediate=" + (this.immediate == null ? "<notset>" : this.immediate) + ", abstract=" + this.isAbstract + ", isDS=" + this.isDs + (this.factory != null ? ", factory=" + this.factory : "") + (this.configurationPolicy != null ? ", configurationPolicy=" + this.configurationPolicy : "") + (this.activate != null ? ", activate=" + this.activate : "") + (this.deactivate != null ? ", deactivate=" + this.deactivate : "") + (this.modified != null ? ", modified=" + this.modified : "") + ", specVersion=" + this.specVersion + ", implementation=" + this.implementation + ", service=" + this.service + ", properties=" + this.properties + ", references=" + this.references + ")";
    }
}

