/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags;

import java.lang.reflect.Array;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    public static String[] getInitializationExpression(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(null);
            if (value != null) {
                if (value.getClass().isArray()) {
                    String[] values = new String[Array.getLength(value)];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = Array.get(value, i).toString();
                    }
                    return values;
                }
                return new String[]{value.toString()};
            }
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new IllegalArgumentException("A class could not be found while parsing class " + clazz.getName() + ". Please check this stracktrace and add a dependency with the missing class to your project.", ncdfe);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class<?> getClass(ClassLoader classLoader, String name) {
        if (classLoader == null) {
            return null;
        }
        try {
            if (name.endsWith(".class")) {
                name = name.substring(0, name.length() - 6);
            }
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

