/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.annotation;

import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.scrplugin.JavaClassDescriptorManager;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.annotation.AnnotationJavaField;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaClassDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationJavaClassDescription
extends QDoxJavaClassDescription {
    public AnnotationJavaClassDescription(Class<?> clazz, JavaClass javaClass, JavaClassDescriptorManager manager) {
        super(clazz, javaClass, manager);
    }

    public ClassLoader getClassLoader() {
        return this.manager.getClassLoader();
    }

    @Override
    public JavaTag getTagByName(String name) {
        for (Annotation annotation : this.javaClass.getAnnotations()) {
            List<JavaTag> tags = this.manager.getAnnotationTagProviderManager().getTags(annotation, this);
            for (JavaTag tag : tags) {
                if (!tag.getName().equals(name)) continue;
                return tag;
            }
        }
        return null;
    }

    @Override
    public JavaTag[] getTagsByName(String name, boolean inherited) throws SCRDescriptorException {
        JavaTag[] superTags;
        ArrayList<JavaTag> tags = new ArrayList<JavaTag>();
        for (Annotation annotation : this.javaClass.getAnnotations()) {
            List<JavaTag> annotationTags = this.manager.getAnnotationTagProviderManager().getTags(annotation, this);
            for (JavaTag tag : annotationTags) {
                if (!tag.getName().equals(name)) continue;
                tags.add(tag);
            }
        }
        if (inherited && this.getSuperClass() != null && (superTags = this.getSuperClass().getTagsByName(name, inherited)).length > 0) {
            tags.addAll(Arrays.asList(superTags));
        }
        return tags.toArray(new JavaTag[tags.size()]);
    }

    @Override
    public JavaField[] getFields() {
        com.thoughtworks.qdox.model.JavaField[] fields = this.javaClass.getFields();
        if (fields == null || fields.length == 0) {
            return new JavaField[0];
        }
        JavaField[] javaFields = new JavaField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            javaFields[i] = new AnnotationJavaField(fields[i], this);
        }
        return javaFields;
    }

    @Override
    public JavaField getFieldByName(String name) throws SCRDescriptorException {
        com.thoughtworks.qdox.model.JavaField field = this.javaClass.getFieldByName(name);
        if (field != null) {
            return new AnnotationJavaField(field, this);
        }
        if (this.getSuperClass() != null) {
            this.getSuperClass().getFieldByName(name);
        }
        return null;
    }

    protected JavaClassDescriptorManager getManager() {
        return this.manager;
    }
}

