/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.annotation;

import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.annotation.AnnotationJavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationTagProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTagProviderManager {
    private final Map<String, AnnotationTagProvider> annotationTagProviders = new LinkedHashMap<String, AnnotationTagProvider>();

    public AnnotationTagProviderManager(String[] annotationTagProviderClasses, ClassLoader classLoader) throws SCRDescriptorFailureException {
        Iterator<AnnotationTagProvider> serviceIter = ServiceRegistry.lookupProviders(AnnotationTagProvider.class, classLoader);
        while (serviceIter.hasNext()) {
            AnnotationTagProvider provider = serviceIter.next();
            this.addProvider(provider);
        }
        for (int i = 0; i < annotationTagProviderClasses.length; ++i) {
            this.loadProvider(classLoader, annotationTagProviderClasses[i], false);
        }
        this.loadProvider(classLoader, "org.apache.felix.scrplugin.tags.annotation.defaulttag.DefaultAnnotationTagProvider", true);
        this.loadProvider(classLoader, "org.apache.felix.scrplugin.tags.annotation.sling.SlingAnnotationTagProvider", true);
    }

    private void addProvider(AnnotationTagProvider provider) {
        String key = provider.getClass().getName();
        if (!this.annotationTagProviders.containsKey(key)) {
            this.annotationTagProviders.put(key, provider);
        }
    }

    private void loadProvider(ClassLoader classLoader, String className, boolean silent) throws SCRDescriptorFailureException {
        String failureMessage = null;
        try {
            Class<?> clazz = classLoader.loadClass(className);
            try {
                this.addProvider((AnnotationTagProvider)clazz.newInstance());
            }
            catch (ClassCastException e) {
                failureMessage = "Class '" + clazz.getName() + "' " + "does not implement interface '" + AnnotationTagProvider.class.getName() + "'.";
            }
            catch (InstantiationException e) {
                failureMessage = "Unable to instantiate class '" + clazz.getName() + "': " + e.getMessage();
            }
            catch (IllegalAccessException e) {
                failureMessage = "Illegal access to class '" + clazz.getName() + "': " + e.getMessage();
            }
        }
        catch (ClassNotFoundException e) {
            failureMessage = "Annotation provider class '" + className + "' not found.";
        }
        if (failureMessage != null && !silent) {
            throw new SCRDescriptorFailureException(failureMessage);
        }
    }

    public List<JavaTag> getTags(Annotation annotation, AnnotationJavaClassDescription description) {
        return this.getTags(annotation, description, null);
    }

    public List<JavaTag> getTags(Annotation annotation, AnnotationJavaClassDescription description, JavaField field) {
        ArrayList<JavaTag> tags = new ArrayList<JavaTag>();
        for (AnnotationTagProvider provider : this.annotationTagProviders.values()) {
            tags.addAll(provider.getTags(annotation, description, field));
        }
        return tags;
    }

    public boolean hasScrPluginAnnotation(JavaClass pClass, AnnotationJavaClassDescription description) {
        for (Annotation annotation : pClass.getAnnotations()) {
            if (this.getTags(annotation, description).size() <= 0) continue;
            return true;
        }
        return false;
    }
}

