/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Components;
import org.apache.felix.scrplugin.om.Implementation;
import org.apache.felix.scrplugin.om.Interface;
import org.apache.felix.scrplugin.om.Property;
import org.apache.felix.scrplugin.om.Reference;
import org.apache.felix.scrplugin.om.Service;
import org.apache.felix.scrplugin.xml.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentDescriptorIO {
    public static final String NAMESPACE_URI_1_0 = "http://www.osgi.org/xmlns/scr/v1.0.0";
    public static final String NAMESPACE_URI_1_1 = "http://www.osgi.org/xmlns/scr/v1.1.0";
    public static final String NAMESPACE_URI_1_1_FELIX = "http://felix.apache.org/xmlns/scr/v1.1.0-felix";
    public static final String INNER_NAMESPACE_URI = "";
    private static final String PREFIX = "scr";
    private static final String COMPONENTS = "components";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_QNAME = "scr:component";
    private static final String COMPONENT_ATTR_ENABLED = "enabled";
    private static final String COMPONENT_ATTR_POLICY = "configuration-policy";
    private static final String COMPONENT_ATTR_FACTORY = "factory";
    private static final String COMPONENT_ATTR_IMMEDIATE = "immediate";
    private static final String COMPONENT_ATTR_NAME = "name";
    private static final String COMPONENT_ATTR_ACTIVATE = "activate";
    private static final String COMPONENT_ATTR_DEACTIVATE = "deactivate";
    private static final String COMPONENT_ATTR_MODIFIED = "modified";
    private static final String IMPLEMENTATION = "implementation";
    private static final String IMPLEMENTATION_QNAME = "implementation";
    private static final String SERVICE = "service";
    private static final String SERVICE_QNAME = "service";
    private static final String PROPERTY = "property";
    private static final String PROPERTY_QNAME = "property";
    private static final String REFERENCE = "reference";
    private static final String REFERENCE_QNAME = "reference";
    private static final String INTERFACE = "provide";
    private static final String INTERFACE_QNAME = "provide";

    public static Components read(InputStream file) throws SCRDescriptorException {
        try {
            XmlHandler xmlHandler = new XmlHandler();
            IOUtils.parse(file, xmlHandler);
            return xmlHandler.components;
        }
        catch (TransformerException e) {
            throw new SCRDescriptorException("Unable to read xml", "[stream]", 0, e);
        }
    }

    public static void write(Components components, File file, boolean isScrPrivateFile) throws SCRDescriptorException {
        try {
            ComponentDescriptorIO.generateXML(components, IOUtils.getSerializer(file), isScrPrivateFile);
        }
        catch (TransformerException e) {
            throw new SCRDescriptorException("Unable to write xml", file.toString(), 0, e);
        }
        catch (SAXException e) {
            throw new SCRDescriptorException("Unable to generate xml", file.toString(), 0, e);
        }
        catch (IOException e) {
            throw new SCRDescriptorException("Unable to write xml", file.toString(), 0, e);
        }
    }

    protected static void generateXML(Components components, ContentHandler contentHandler, boolean isScrPrivateFile) throws SAXException {
        String namespace = components.getSpecVersion() == 0 ? NAMESPACE_URI_1_0 : (components.getSpecVersion() == 1 ? NAMESPACE_URI_1_1 : NAMESPACE_URI_1_1_FELIX);
        contentHandler.startDocument();
        contentHandler.startPrefixMapping(PREFIX, namespace);
        contentHandler.startElement(INNER_NAMESPACE_URI, COMPONENTS, COMPONENTS, new AttributesImpl());
        IOUtils.newline(contentHandler);
        for (Component component : components.getComponents()) {
            if (!component.isDs()) continue;
            ComponentDescriptorIO.generateXML(namespace, component, contentHandler, isScrPrivateFile);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, COMPONENTS, COMPONENTS);
        IOUtils.newline(contentHandler);
        contentHandler.endPrefixMapping(PREFIX);
        contentHandler.endDocument();
    }

    protected static void generateXML(String namespace, Component component, ContentHandler contentHandler, boolean isScrPrivateFile) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, COMPONENT_ATTR_ENABLED, component.isEnabled());
        IOUtils.addAttribute(ai, COMPONENT_ATTR_IMMEDIATE, component.isImmediate());
        IOUtils.addAttribute(ai, COMPONENT_ATTR_NAME, component.getName());
        IOUtils.addAttribute(ai, COMPONENT_ATTR_FACTORY, component.getFactory());
        if (NAMESPACE_URI_1_1.equals(namespace) || NAMESPACE_URI_1_1_FELIX.equals(namespace)) {
            IOUtils.addAttribute(ai, COMPONENT_ATTR_POLICY, component.getConfigurationPolicy());
            IOUtils.addAttribute(ai, COMPONENT_ATTR_ACTIVATE, component.getActivate());
            IOUtils.addAttribute(ai, COMPONENT_ATTR_DEACTIVATE, component.getDeactivate());
            IOUtils.addAttribute(ai, COMPONENT_ATTR_MODIFIED, component.getModified());
        }
        IOUtils.indent(contentHandler, 1);
        contentHandler.startElement(namespace, COMPONENT, COMPONENT_QNAME, ai);
        IOUtils.newline(contentHandler);
        ComponentDescriptorIO.generateXML(component.getImplementation(), contentHandler);
        if (component.getService() != null) {
            ComponentDescriptorIO.generateXML(component.getService(), contentHandler);
        }
        if (component.getProperties() != null) {
            for (Property property : component.getProperties()) {
                ComponentDescriptorIO.generateXML(property, contentHandler, isScrPrivateFile);
            }
        }
        if (component.getReferences() != null) {
            for (Reference reference : component.getReferences()) {
                ComponentDescriptorIO.generateXML(namespace, reference, contentHandler, isScrPrivateFile);
            }
        }
        IOUtils.indent(contentHandler, 1);
        contentHandler.endElement(namespace, COMPONENT, COMPONENT_QNAME);
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Implementation implementation, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "class", implementation.getClassame());
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "implementation", "implementation", ai);
        contentHandler.endElement(INNER_NAMESPACE_URI, "implementation", "implementation");
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Service service, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "servicefactory", String.valueOf(service.isServicefactory()));
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "service", "service", ai);
        if (service.getInterfaces() != null && service.getInterfaces().size() > 0) {
            IOUtils.newline(contentHandler);
            for (Interface interf : service.getInterfaces()) {
                ComponentDescriptorIO.generateXML(interf, contentHandler);
            }
            IOUtils.indent(contentHandler, 2);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, "service", "service");
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Interface interf, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "interface", interf.getInterfacename());
        IOUtils.indent(contentHandler, 3);
        contentHandler.startElement(INNER_NAMESPACE_URI, "provide", "provide", ai);
        contentHandler.endElement(INNER_NAMESPACE_URI, "provide", "provide");
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Property property, ContentHandler contentHandler, boolean isScrPrivateFile) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, COMPONENT_ATTR_NAME, property.getName());
        IOUtils.addAttribute(ai, "type", property.getType());
        IOUtils.addAttribute(ai, "value", property.getValue());
        if (isScrPrivateFile) {
            IOUtils.addAttribute(ai, "private", String.valueOf(property.isPrivate()));
            if (property.getLabel() != null) {
                IOUtils.addAttribute(ai, "label", String.valueOf(property.getLabel()));
            }
            if (property.getDescription() != null) {
                IOUtils.addAttribute(ai, "description", String.valueOf(property.getDescription()));
            }
            if (property.getCardinality() != null) {
                IOUtils.addAttribute(ai, "cardinality", String.valueOf(property.getCardinality()));
            }
        }
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "property", "property", ai);
        if (property.getMultiValue() != null && property.getMultiValue().length > 0) {
            IOUtils.text(contentHandler, "\n");
            for (int i = 0; i < property.getMultiValue().length; ++i) {
                IOUtils.indent(contentHandler, 3);
                IOUtils.text(contentHandler, property.getMultiValue()[i]);
                IOUtils.newline(contentHandler);
            }
            IOUtils.indent(contentHandler, 2);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, "property", "property");
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(String namespace, Reference reference, ContentHandler contentHandler, boolean isScrPrivateFile) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, COMPONENT_ATTR_NAME, reference.getName());
        IOUtils.addAttribute(ai, "interface", reference.getInterfacename());
        IOUtils.addAttribute(ai, "cardinality", reference.getCardinality());
        IOUtils.addAttribute(ai, "policy", reference.getPolicy());
        IOUtils.addAttribute(ai, "target", reference.getTarget());
        IOUtils.addAttribute(ai, "bind", reference.getBind());
        IOUtils.addAttribute(ai, "unbind", reference.getUnbind());
        if (NAMESPACE_URI_1_1_FELIX.equals(namespace)) {
            IOUtils.addAttribute(ai, "updated", reference.getUpdated());
        }
        if (isScrPrivateFile) {
            IOUtils.addAttribute(ai, "checked", String.valueOf(reference.isChecked()));
            IOUtils.addAttribute(ai, "strategy", reference.getStrategy());
        }
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "reference", "reference", ai);
        contentHandler.endElement(INNER_NAMESPACE_URI, "reference", "reference");
        IOUtils.newline(contentHandler);
    }

    protected static final class XmlHandler
    extends DefaultHandler {
        protected final Components components = new Components();
        protected Component currentComponent;
        protected Service currentService;
        protected Property pendingProperty;
        protected boolean firstElement = true;
        protected boolean isComponent = false;
        protected String overrideNamespace;

        protected XmlHandler() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.firstElement) {
                this.firstElement = false;
                if (localName.equals(ComponentDescriptorIO.COMPONENT) && ComponentDescriptorIO.INNER_NAMESPACE_URI.equals(uri)) {
                    this.overrideNamespace = ComponentDescriptorIO.NAMESPACE_URI_1_0;
                }
            }
            if (this.overrideNamespace != null && ComponentDescriptorIO.INNER_NAMESPACE_URI.equals(uri)) {
                uri = this.overrideNamespace;
            }
            if (this.isComponent && ComponentDescriptorIO.INNER_NAMESPACE_URI.equals(uri)) {
                uri = ComponentDescriptorIO.NAMESPACE_URI_1_0;
            }
            if (ComponentDescriptorIO.NAMESPACE_URI_1_0.equals(uri) || ComponentDescriptorIO.NAMESPACE_URI_1_1.equals(uri) || ComponentDescriptorIO.NAMESPACE_URI_1_1_FELIX.equals(uri)) {
                if (ComponentDescriptorIO.NAMESPACE_URI_1_1.equals(uri)) {
                    this.components.setSpecVersion(1);
                } else if (ComponentDescriptorIO.NAMESPACE_URI_1_1_FELIX.equals(uri)) {
                    this.components.setSpecVersion(2);
                }
                if (localName.equals(ComponentDescriptorIO.COMPONENT)) {
                    this.isComponent = true;
                    this.currentComponent = new Component();
                    this.currentComponent.setName(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_NAME));
                    if (attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_ENABLED) != null) {
                        this.currentComponent.setEnabled(Boolean.valueOf(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_ENABLED)));
                    }
                    if (attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_IMMEDIATE) != null) {
                        this.currentComponent.setImmediate(Boolean.valueOf(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_IMMEDIATE)));
                    }
                    this.currentComponent.setFactory(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_FACTORY));
                    if (this.components.getSpecVersion() == 1) {
                        this.currentComponent.setConfigurationPolicy(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_POLICY));
                        this.currentComponent.setActivate(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_ACTIVATE));
                        this.currentComponent.setDeactivate(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_DEACTIVATE));
                        this.currentComponent.setModified(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_MODIFIED));
                    }
                } else if (localName.equals("implementation")) {
                    Implementation impl = new Implementation();
                    this.currentComponent.setImplementation(impl);
                    impl.setClassname(attributes.getValue("class"));
                } else if (localName.equals("property")) {
                    String propName = attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_NAME);
                    if (!"service.pid".equals(propName)) {
                        Property prop = new Property();
                        prop.setName(propName);
                        prop.setType(attributes.getValue("type"));
                        if (attributes.getValue("value") != null) {
                            prop.setValue(attributes.getValue("value"));
                            this.currentComponent.addProperty(prop);
                        } else {
                            this.pendingProperty = prop;
                        }
                        prop.setLabel(attributes.getValue("label"));
                        prop.setDescription(attributes.getValue("description"));
                        prop.setCardinality(attributes.getValue("cardinality"));
                        String pValue = attributes.getValue("private");
                        if (pValue != null) {
                            prop.setPrivate(Boolean.valueOf(pValue));
                        }
                    }
                } else if (!localName.equals("properties")) {
                    if (localName.equals("service")) {
                        this.currentService = new Service();
                        this.currentService.setServicefactory(attributes.getValue("servicefactory"));
                        this.currentComponent.setService(this.currentService);
                    } else if (localName.equals("provide")) {
                        Interface interf = new Interface();
                        this.currentService.addInterface(interf);
                        interf.setInterfacename(attributes.getValue("interface"));
                    } else if (localName.equals("reference")) {
                        Reference ref = new Reference();
                        ref.setName(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_NAME));
                        ref.setInterfacename(attributes.getValue("interface"));
                        ref.setCardinality(attributes.getValue("cardinality"));
                        ref.setPolicy(attributes.getValue("policy"));
                        ref.setTarget(attributes.getValue("target"));
                        ref.setBind(attributes.getValue("bind"));
                        ref.setUnbind(attributes.getValue("unbind"));
                        if (attributes.getValue("checked") != null) {
                            ref.setChecked(Boolean.valueOf(attributes.getValue("checked")));
                        }
                        if (attributes.getValue("strategy") != null) {
                            ref.setStrategy(attributes.getValue("strategy"));
                        }
                        this.currentComponent.addReference(ref);
                    }
                }
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.overrideNamespace != null && ComponentDescriptorIO.INNER_NAMESPACE_URI.equals(uri)) {
                uri = this.overrideNamespace;
            }
            if (this.isComponent && ComponentDescriptorIO.INNER_NAMESPACE_URI.equals(uri)) {
                uri = ComponentDescriptorIO.NAMESPACE_URI_1_0;
            }
            if (ComponentDescriptorIO.NAMESPACE_URI_1_0.equals(uri) || ComponentDescriptorIO.NAMESPACE_URI_1_1.equals(uri) || ComponentDescriptorIO.NAMESPACE_URI_1_1_FELIX.equals(uri)) {
                if (localName.equals(ComponentDescriptorIO.COMPONENT)) {
                    this.components.addComponent(this.currentComponent);
                    this.currentComponent = null;
                    this.isComponent = false;
                } else if (localName.equals("property") && this.pendingProperty != null) {
                    String text = this.pendingProperty.getValue();
                    if (text != null) {
                        StringTokenizer st = new StringTokenizer(text);
                        String[] values = new String[st.countTokens()];
                        int index = 0;
                        while (st.hasMoreTokens()) {
                            values[index] = st.nextToken();
                            ++index;
                        }
                        this.pendingProperty.setMultiValue(values);
                    }
                    this.currentComponent.addProperty(this.pendingProperty);
                    this.pendingProperty = null;
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.pendingProperty != null) {
                String text = new String(ch, start, length);
                if (this.pendingProperty.getValue() == null) {
                    this.pendingProperty.setValue(text);
                } else {
                    this.pendingProperty.setValue(this.pendingProperty.getValue() + text);
                }
            }
        }
    }
}

