/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.FloatingPointNumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Floats;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractFloatAssert<S extends AbstractFloatAssert<S>>
extends AbstractComparableAssert<S, Float>
implements FloatingPointNumberAssert<S, Float> {
    @VisibleForTesting
    Floats floats = Floats.instance();

    public AbstractFloatAssert(Float actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public S isNaN() {
        this.floats.assertIsNaN(this.info, (Number)this.actual);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isNotNaN() {
        this.floats.assertIsNotNaN(this.info, (Number)this.actual);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isZero() {
        this.floats.assertIsZero(this.info, (Number)this.actual);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isNotZero() {
        this.floats.assertIsNotZero(this.info, (Number)this.actual);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isPositive() {
        this.floats.assertIsPositive(this.info, (Number)this.actual);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isNegative() {
        this.floats.assertIsNegative(this.info, (Number)this.actual);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isNotNegative() {
        this.floats.assertIsNotNegative(this.info, (Number)this.actual);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isNotPositive() {
        this.floats.assertIsNotPositive(this.info, (Number)this.actual);
        return (S)((AbstractFloatAssert)this.myself);
    }

    public S isEqualTo(float expected) {
        this.floats.assertEqual(this.info, this.actual, Float.valueOf(expected));
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isCloseTo(float other, Offset<Float> offset) {
        this.floats.assertIsCloseTo(this.info, (Number)this.actual, Float.valueOf(other), offset);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isCloseTo(Float other, Offset<Float> offset) {
        this.floats.assertIsCloseTo(this.info, (Number)this.actual, other, offset);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isCloseTo(Float expected, Percentage percentage) {
        this.floats.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isCloseTo(float expected, Percentage percentage) {
        this.floats.assertIsCloseToPercentage(this.info, (Number)this.actual, Float.valueOf(expected), percentage);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isEqualTo(Float expected, Offset<Float> offset) {
        this.floats.assertEqual(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isEqualTo(float expected, Offset<Float> offset) {
        this.floats.assertEqual(this.info, (Number)this.actual, Float.valueOf(expected), offset);
        return (S)((AbstractFloatAssert)this.myself);
    }

    public S isNotEqualTo(float other) {
        this.floats.assertNotEqual(this.info, this.actual, Float.valueOf(other));
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isLessThan(float other) {
        this.floats.assertLessThan(this.info, (Comparable)this.actual, Float.valueOf(other));
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isLessThanOrEqualTo(float other) {
        this.floats.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, Float.valueOf(other));
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isGreaterThan(float other) {
        this.floats.assertGreaterThan(this.info, (Comparable)this.actual, Float.valueOf(other));
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isGreaterThanOrEqualTo(float other) {
        this.floats.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, Float.valueOf(other));
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isBetween(Float start, Float end) {
        this.floats.assertIsBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S isStrictlyBetween(Float start, Float end) {
        this.floats.assertIsStrictlyBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S usingComparator(Comparator<? super Float> customComparator) {
        super.usingComparator(customComparator);
        this.floats = new Floats(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractFloatAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.floats = Floats.instance();
        return (S)((AbstractFloatAssert)this.myself);
    }
}

