/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.util.AntBuildListener;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.spi.AbstractLocalContainer;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractInstalledLocalContainer
extends AbstractLocalContainer
implements InstalledLocalContainer {
    private Map systemProperties;
    private String[] extraClasspath;
    private String home;
    private JdkUtils jdkUtils = new JdkUtils();
    private AntUtils antUtils;
    private HttpUtils httpUtils;
    private ResourceUtils resourceUtils;
    private FileHandler fileHandler = new DefaultFileHandler();

    public AbstractInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
        this.antUtils = new AntUtils();
        this.resourceUtils = new ResourceUtils();
        this.httpUtils = new HttpUtils();
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.resourceUtils.setLogger(logger);
        this.httpUtils.setLogger(logger);
    }

    protected final HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    protected final JdkUtils getJdkUtils() {
        return this.jdkUtils;
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public final void setHome(String home) {
        this.home = home;
    }

    public void setSystemProperties(Map properties) {
        HashMap props = new HashMap();
        props.putAll(properties);
        this.systemProperties = props;
    }

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public void setExtraClasspath(String[] classpath) {
        this.extraClasspath = classpath;
    }

    public String[] getExtraClasspath() {
        return this.extraClasspath;
    }

    public final String getHome() {
        return this.home;
    }

    protected abstract void doStart(Java var1) throws Exception;

    protected abstract void doStop(Java var1) throws Exception;

    protected final void startInternal() throws Exception {
        this.doStart(this.createJavaTask());
    }

    protected final void stopInternal() throws Exception {
        this.doStop(this.createJavaTask());
    }

    private Java createJavaTask() {
        Java java = (Java)this.getAntUtils().createAntTask("java");
        java.setFork(true);
        if (this.getOutput() != null) {
            java.setOutput(new File(this.getOutput()));
            java.setAppend(this.isAppend());
        }
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getLogger(), this.getClass().getName()));
        this.addExtraClasspath(java);
        this.addSystemProperties(java);
        String jvmargs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmargs != null) {
            java.createJvmarg().setLine(jvmargs);
        }
        return java;
    }

    private void addSystemProperties(Java java) {
        if (this.getSystemProperties() != null) {
            Iterator keys = this.getSystemProperties().keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                java.addSysproperty(this.getAntUtils().createSysProperty(key, (String)this.getSystemProperties().get(key)));
            }
        }
    }

    protected final void addToolsJarToClasspath(Path classpath) throws FileNotFoundException {
        if (!this.getJdkUtils().isOSX()) {
            classpath.createPathElement().setLocation(this.getJdkUtils().getToolsJar());
        }
    }

    private void addExtraClasspath(Java javaCommand) {
        Path classpath = javaCommand.createClasspath();
        if (this.getExtraClasspath() != null) {
            Path path = new Path(this.getAntUtils().createProject());
            for (int i = 0; i < this.getExtraClasspath().length; ++i) {
                Path pathElement = new Path(this.getAntUtils().createProject(), this.getExtraClasspath()[i]);
                path.addExisting(pathElement);
                this.getLogger().debug("Adding [" + pathElement + "] to execution classpath", this.getClass().getName());
            }
            classpath.addExisting(path);
        }
    }

    protected void verify() {
        super.verify();
        this.verifyHome();
    }

    private void verifyHome() {
        if (this.getHome() == null) {
            throw new ContainerException("You must set the mandatory [home] property");
        }
        if (!this.getFileHandler().isDirectory(this.getHome())) {
            throw new ContainerException("[" + this.getHome() + "] is not a directory. It must point " + "to the container home directory.");
        }
    }

    public ContainerType getType() {
        return ContainerType.INSTALLED;
    }
}

