/* 
 * ========================================================================
 * 
 * Copyright 2004-2005 Vincent Massol.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * ========================================================================
 */
package org.codehaus.cargo.module.merge;

import org.codehaus.cargo.util.CargoException;

/**
 * Class for various exceptions happening within merges.
 * 
 * @version $Id: $
 */
public class MergeException extends CargoException
{
    /**
     * @param string in string to describe the exception
     */
    public MergeException(String string)
    {
        super(string);
    }
    
    /**
     * @param string in string to describe the exception
     * @param e in exception causing error
     */
    public MergeException(String string, Throwable e)
    {
        super(string, e);
    }
}
