/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.merge;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.codehaus.cargo.module.AbstractDescriptorIo;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DocumentStreamAdapter
extends AbstractDescriptorIo
implements MergeProcessor {
    private MergeProcessor next;

    public DocumentStreamAdapter(MergeProcessor next) {
        this.next = next;
    }

    public void addMergeItem(Object mergeItem) throws MergeException {
        if (mergeItem instanceof InputStream) {
            try {
                this.next.addMergeItem(this.getDocument((InputStream)mergeItem));
            }
            catch (Exception e) {
                throw new MergeException("Exception creating document", e);
            }
        } else {
            throw new MergeException("DocumentMerger can only merge InputStreams");
        }
    }

    public Object performMerge() throws MergeException {
        try {
            Document doc = (Document)this.next.performMerge();
            if (doc == null) {
                return null;
            }
            OutputFormat outputFormat = new OutputFormat(doc);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLSerializer serializer = new XMLSerializer((OutputStream)out, outputFormat);
            serializer.serialize(doc);
            byte[] data = out.toByteArray();
            return new ByteArrayInputStream(data);
        }
        catch (Exception e) {
            throw new MergeException("Error whilst merging documents", e);
        }
    }

    protected Document getDocument(InputStream theInput) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DocumentStreamAdapter.createDocumentBuilder();
        return builder.parse(theInput);
    }
}

