/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.cargo.module.AbstractDescriptorIo;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class WebXmlIo
extends AbstractDescriptorIo {
    private WebXmlIo() {
    }

    public static WebXml newWebXml(WebXmlVersion theVersion) throws ParserConfigurationException {
        DocumentBuilder builder = WebXmlIo.createDocumentBuilder();
        DocumentType docType = null;
        if (theVersion != null) {
            docType = builder.getDOMImplementation().createDocumentType("web-app", theVersion.getPublicId(), theVersion.getSystemId());
        }
        Document doc = builder.getDOMImplementation().createDocument("", "web-app", docType);
        return new WebXml(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebXml parseWebXmlFromFile(File theFile, EntityResolver theEntityResolver) throws SAXException, ParserConfigurationException, IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(theFile);
            WebXml webXml = WebXmlIo.parseWebXml(in, theEntityResolver);
            return webXml;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static WebXml parseWebXml(InputStream theInput, EntityResolver theEntityResolver) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilder builder = WebXmlIo.createDocumentBuilder();
        if (theEntityResolver != null) {
            builder.setEntityResolver(theEntityResolver);
        } else {
            builder.setEntityResolver(new WebXmlEntityResolver());
        }
        return new WebXml(builder.parse(theInput));
    }

    private static class WebXmlEntityResolver
    implements EntityResolver {
        private WebXmlEntityResolver() {
        }

        public InputSource resolveEntity(String thePublicId, String theSystemId) throws SAXException, IOException {
            WebXmlVersion version = WebXmlVersion.valueOf(thePublicId);
            if (version != null) {
                String fileName = version.getSystemId().substring(version.getSystemId().lastIndexOf(47));
                InputStream in = this.getClass().getResourceAsStream("/org/codehaus/cargo/module/internal/resource" + fileName);
                if (in != null) {
                    return new InputSource(in);
                }
            }
            return null;
        }
    }
}

