/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.util.Iterator;
import org.codehaus.cargo.module.internal.util.xml.AbstractNodeList;
import org.codehaus.cargo.module.merge.AbstractMergeSet;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeNodeList;
import org.codehaus.cargo.module.merge.strategy.MergeStrategy;
import org.codehaus.cargo.module.webapp.VendorWebAppDescriptor;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlTag;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.codehaus.cargo.module.webapp.resin.ResinWebXml;
import org.codehaus.cargo.module.webapp.resin.ResinWebXmlMerger;
import org.codehaus.cargo.util.log.LoggedObject;
import org.w3c.dom.Element;

public class WebXmlMerger
extends LoggedObject {
    protected MergeStrategy mergeContextParamsStrategy = MergeStrategy.PRESERVE;
    protected MergeStrategy mergeListenerStrategy = MergeStrategy.PRESERVE;
    private WebXml webXml;

    public WebXmlMerger(WebXml theWebXml) {
        this.webXml = theWebXml;
    }

    public void setMergeContextParamsStrategy(MergeStrategy ms) {
        this.mergeContextParamsStrategy = ms;
    }

    public final void merge(WebXml theMergeWebXml) {
        try {
            this.checkServletVersions(theMergeWebXml);
            this.mergeContextParams(theMergeWebXml);
            if (WebXmlVersion.V2_3.compareTo(this.webXml.getVersion()) <= 0) {
                this.mergeFilters(theMergeWebXml);
            }
            this.mergeServlets(theMergeWebXml);
            if (WebXmlVersion.V2_3.compareTo(this.webXml.getVersion()) <= 0) {
                this.mergeResourceEnvironmentReferences(theMergeWebXml);
            }
            this.mergeListeners(theMergeWebXml);
            this.mergeResourceReferences(theMergeWebXml);
            this.mergeSecurityConstraints(theMergeWebXml);
            this.mergeLoginConfig(theMergeWebXml);
            this.mergeSecurityRoles(theMergeWebXml);
            this.mergeEnvironmentEntries(theMergeWebXml);
            this.mergeEjbRefs(theMergeWebXml);
            if (WebXmlVersion.V2_3.compareTo(this.webXml.getVersion()) <= 0) {
                this.mergeEjbLocalRefs(theMergeWebXml);
            }
            this.mergeVendorDescriptors(theMergeWebXml);
        }
        catch (Exception e) {
            throw new MergeException("Exception merging web.xml files", e);
        }
    }

    protected final void mergeVendorDescriptors(WebXml theWebXml) {
        this.mergeVendorDescriptors(theWebXml, ResinWebXml.class, new IMergeImplementation(){

            public void merge(VendorWebAppDescriptor ours, VendorWebAppDescriptor theirs) {
                ResinWebXmlMerger merger = new ResinWebXmlMerger((ResinWebXml)ours);
                merger.merge((ResinWebXml)theirs);
            }
        });
    }

    protected final void mergeVendorDescriptors(WebXml theWebXml, Class clazz, IMergeImplementation merger) {
        VendorWebAppDescriptor descriptorOurs = this.getVendorWebAppDescriptor(this.webXml, clazz);
        VendorWebAppDescriptor descriptorTheirs = this.getVendorWebAppDescriptor(theWebXml, clazz);
        if (descriptorTheirs != null) {
            if (descriptorOurs == null) {
                this.webXml.addVendorDescriptor(descriptorTheirs);
            } else {
                merger.merge(descriptorOurs, descriptorTheirs);
            }
        }
    }

    protected VendorWebAppDescriptor getVendorWebAppDescriptor(WebXml theWebXml, Class clazz) {
        Iterator i = theWebXml.getVendorDescriptors();
        while (i.hasNext()) {
            VendorWebAppDescriptor descriptor = (VendorWebAppDescriptor)i.next();
            if (!clazz.isInstance(descriptor)) continue;
            return descriptor;
        }
        return null;
    }

    protected final void checkServletVersions(WebXml theWebXml) {
        if (this.webXml.getVersion() != null && this.webXml.getVersion().compareTo(theWebXml.getVersion()) < 0) {
            this.getLogger().warn("Merging elements from a version " + theWebXml.getVersion() + " descriptor into a version " + this.webXml.getVersion() + ", some elements may be skipped", ((Object)((Object)this)).getClass().getName());
        }
    }

    protected final void mergeContextParams(WebXml theWebXml) throws MergeException {
        AbstractNodeList ourItems = this.webXml.getContextParams();
        AbstractNodeList mergeItems = theWebXml.getContextParams();
        AbstractMergeSet merger = MergeNodeList.createFromNames(ourItems, mergeItems);
        try {
            int count = merger.merge(this.mergeContextParamsStrategy);
            this.getLogger().debug("Merged " + count + " context-param definition" + (count != 1 ? "s " : " ") + "into the descriptor", ((Object)((Object)this)).getClass().getName());
        }
        catch (Exception e) {
            throw new MergeException("Exception in the merge", e);
        }
    }

    protected final void mergeFilters(WebXml theWebXml) {
        Iterator filterNames = theWebXml.getFilterNames();
        int count = 0;
        while (filterNames.hasNext()) {
            String filterName = (String)filterNames.next();
            if (!this.webXml.hasFilter(filterName)) {
                this.webXml.addFilter(theWebXml.getFilter(filterName));
            } else {
                Iterator filterInitParamNames = theWebXml.getFilterInitParamNames(filterName);
                while (filterInitParamNames.hasNext()) {
                    String paramName = (String)filterInitParamNames.next();
                    String paramValue = theWebXml.getFilterInitParam(filterName, paramName);
                    this.webXml.addFilterInitParam(filterName, paramName, paramValue);
                }
            }
            Iterator filterMappings = theWebXml.getFilterMappings(filterName);
            while (filterMappings.hasNext()) {
                String urlPattern = (String)filterMappings.next();
                this.webXml.addFilterMapping(filterName, urlPattern);
            }
            ++count;
        }
        this.getLogger().debug("Merged " + count + " filter definition" + (count != 1 ? "s " : " ") + "into the descriptor", ((Object)((Object)this)).getClass().getName());
    }

    protected final void mergeServlets(WebXml theWebXml) {
        Iterator servletNames = theWebXml.getServletNames();
        int count = 0;
        while (servletNames.hasNext()) {
            String servletName = (String)servletNames.next();
            if (!this.webXml.hasServlet(servletName)) {
                this.webXml.addServlet(theWebXml.getServlet(servletName));
            } else {
                Iterator servletInitParamNames = theWebXml.getServletInitParamNames(servletName);
                while (servletInitParamNames.hasNext()) {
                    String paramName = (String)servletInitParamNames.next();
                    String paramValue = theWebXml.getServletInitParam(servletName, paramName);
                    this.webXml.addServletInitParam(servletName, paramName, paramValue);
                }
                String roleName = theWebXml.getServletRunAsRoleName(servletName);
                if (roleName != null) {
                    this.webXml.addServletRunAsRoleName(servletName, roleName);
                }
            }
            Iterator servletMappings = theWebXml.getServletMappings(servletName);
            while (servletMappings.hasNext()) {
                String urlPattern = (String)servletMappings.next();
                this.webXml.addServletMapping(servletName, urlPattern);
            }
            ++count;
        }
        this.getLogger().debug("Merged " + count + " servlet definition" + (count != 1 ? "s " : " ") + "into the descriptor", ((Object)((Object)this)).getClass().getName());
    }

    protected final void mergeListeners(WebXml theWebXml) {
        AbstractNodeList ourItems = this.webXml.getListeners();
        AbstractNodeList mergeItems = theWebXml.getListeners();
        AbstractMergeSet merger = MergeNodeList.createFromNames(ourItems, mergeItems);
        try {
            int count = merger.merge(this.mergeListenerStrategy);
            this.getLogger().debug("Merged " + count + " listener definition" + (count != 1 ? "s " : " ") + "into the descriptor", ((Object)((Object)this)).getClass().getName());
        }
        catch (Exception e) {
            throw new MergeException("Exception in the merge", e);
        }
    }

    protected final void mergeResourceEnvironmentReferences(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.RESOURCE_ENV_REF);
        if (count > 0) {
            this.getLogger().debug("Merged " + count + " resource environment " + "reference" + (count != 1 ? "s " : " ") + "into the " + "descriptor", ((Object)((Object)this)).getClass().getName());
        }
    }

    protected final void mergeResourceReferences(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.RESOURCE_REF);
        if (count > 0) {
            this.getLogger().debug("Merged " + count + " resource reference" + (count != 1 ? "s " : " ") + "into the descriptor", ((Object)((Object)this)).getClass().getName());
        }
    }

    protected final void mergeSecurityConstraints(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.SECURITY_CONSTRAINT);
        if (count > 0) {
            this.getLogger().debug("Merged " + count + " security constraint" + (count != 1 ? "s " : " ") + "into the descriptor", ((Object)((Object)this)).getClass().getName());
        }
    }

    protected final void mergeLoginConfig(WebXml theWebXml) {
        boolean replaced = this.replaceElement(theWebXml, WebXmlTag.LOGIN_CONFIG);
        if (replaced) {
            this.getLogger().debug("Merged the login configuration into the descriptor", ((Object)((Object)this)).getClass().getName());
        }
    }

    protected final void mergeSecurityRoles(WebXml theWebXml) {
        Iterator securityRoleNames = theWebXml.getSecurityRoleNames();
        int count = 0;
        while (securityRoleNames.hasNext()) {
            String securityRoleName = (String)securityRoleNames.next();
            if (this.webXml.hasSecurityRole(securityRoleName)) continue;
            this.webXml.addSecurityRole(securityRoleName);
        }
        if (count > 0) {
            this.getLogger().debug("Merged " + count + " security roles into the descriptor", ((Object)((Object)this)).getClass().getName());
        }
    }

    protected final void mergeEnvironmentEntries(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.ENV_ENTRY);
        if (count > 0) {
            this.getLogger().debug("Merged " + count + " environment entr" + (count != 1 ? "ies " : "y ") + "into the descriptor", ((Object)((Object)this)).getClass().getName());
        }
    }

    protected final void mergeEjbRefs(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.EJB_REF);
        if (count > 0) {
            this.getLogger().debug("Merged " + count + " EJB reference" + (count != 1 ? "s " : "y ") + "into the descriptor", ((Object)((Object)this)).getClass().getName());
        }
    }

    protected final void mergeEjbLocalRefs(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.EJB_LOCAL_REF);
        if (count > 0) {
            this.getLogger().debug("Merged " + count + " EJB local reference" + (count != 1 ? "s " : "y ") + "into the descriptor", ((Object)((Object)this)).getClass().getName());
        }
    }

    private int insertElements(WebXml theWebXml, WebXmlTag theTag) {
        Iterator elements = theWebXml.getElements(theTag);
        int count = 0;
        while (elements.hasNext()) {
            Element element = (Element)elements.next();
            this.webXml.addRootElement(theTag, element);
            ++count;
        }
        return count;
    }

    private boolean replaceElement(WebXml theWebXml, WebXmlTag theTag) {
        Iterator elements = theWebXml.getElements(theTag);
        if (elements.hasNext()) {
            this.webXml.replaceRootElement(theTag, (Element)elements.next());
            return true;
        }
        return false;
    }

    protected static interface IMergeImplementation {
        public void merge(VendorWebAppDescriptor var1, VendorWebAppDescriptor var2);
    }
}

