/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura.tasks;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.mojo.cobertura.tasks.CommandLineArguments;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractTask {
    protected CommandLineArguments cmdLineArgs;
    private Log log;
    private String maxmem;
    private List pluginClasspathList;
    private String taskClass;

    protected AbstractTask(String taskClassname) {
        this.taskClass = taskClassname;
        this.cmdLineArgs = new CommandLineArguments();
        this.maxmem = "64m";
    }

    public String createClasspath() throws MojoExecutionException {
        StringBuffer cpBuffer = new StringBuffer();
        Iterator it = this.pluginClasspathList.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            try {
                cpBuffer.append(File.pathSeparator).append(artifact.getFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        return cpBuffer.toString();
    }

    private String getLog4jConfigFile() {
        String resourceName = "cobertura-plugin/log4j-info.properties";
        if (this.getLog().isDebugEnabled()) {
            resourceName = "cobertura-plugin/log4j-debug.properties";
        }
        String path = null;
        try {
            File log4jconfigFile = File.createTempFile("log4j", "config.properties");
            URL log4jurl = this.getClass().getClassLoader().getResource(resourceName);
            FileUtils.copyURLToFile((URL)log4jurl, (File)log4jconfigFile);
            log4jconfigFile.deleteOnExit();
            path = log4jconfigFile.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public abstract void execute() throws MojoExecutionException;

    protected int executeJava() throws MojoExecutionException {
        int exitCode;
        Commandline cl = new Commandline();
        cl.setExecutable("java");
        cl.createArgument().setValue("-cp");
        cl.createArgument().setValue(this.createClasspath());
        String log4jConfig = this.getLog4jConfigFile();
        if (log4jConfig != null) {
            cl.createArgument().setValue("-Dlog4j.configuration=" + log4jConfig);
        }
        cl.createArgument().setValue("-Xmx" + this.maxmem);
        cl.createArgument().setValue(this.taskClass);
        if (this.cmdLineArgs.useCommandsFile()) {
            cl.createArgument().setValue("--commandsfile");
            try {
                String commandsFile = this.cmdLineArgs.getCommandsFile();
                cl.createArgument().setValue(commandsFile);
                FileUtils.copyFile((File)new File(commandsFile), (File)new File(commandsFile + ".bak"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to obtain CommandsFile location.", (Exception)e);
            }
        } else {
            Iterator it = this.cmdLineArgs.iterator();
            while (it.hasNext()) {
                cl.createArgument().setValue(it.next().toString());
            }
        }
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLog().debug((CharSequence)("Working Directory: " + cl.getWorkingDirectory()));
        this.getLog().debug((CharSequence)"Executing command line:");
        this.getLog().debug((CharSequence)cl.toString());
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute Cobertura.", (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)("exit code: " + exitCode));
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().debug((CharSequence)" Standard output from the Cobertura task:");
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().info((CharSequence)stdout.getOutput());
        this.getLog().debug((CharSequence)"--------------------");
        String stream = stderr.getOutput();
        if (stream.trim().length() > 0) {
            this.getLog().debug((CharSequence)"--------------------");
            this.getLog().debug((CharSequence)" Standard error from the Cobertura task:");
            this.getLog().debug((CharSequence)"--------------------");
            this.getLog().error((CharSequence)stderr.getOutput());
            this.getLog().debug((CharSequence)"--------------------");
        }
        return exitCode;
    }

    public CommandLineArguments getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public String getMaxmem() {
        return this.maxmem;
    }

    public List getPluginClasspathList() {
        return this.pluginClasspathList;
    }

    public void setCmdLineArgs(CommandLineArguments cmdLineArgs) {
        this.cmdLineArgs = cmdLineArgs;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setMaxmem(String maxmem) {
        this.maxmem = maxmem;
    }

    public void setPluginClasspathList(List pluginClasspathList) {
        this.pluginClasspathList = Collections.unmodifiableList(pluginClasspathList);
    }
}

