/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2;

import com.sun.tools.xjc.Driver;
import com.sun.tools.xjc.XJCListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.jaxb2.NoSchemasException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.SAXParseException;

public abstract class AbstractXjcMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Component
    private MavenProject project;
    @Component
    private MojoExecution execution;
    @Parameter
    protected File generatedResourcesDirectory;
    @Parameter
    protected String packageName;
    @Parameter
    protected File catalog;
    @Parameter
    protected String httpproxy;
    @Parameter
    protected String bindingFiles;
    @Parameter
    protected String schemaFiles;
    @Parameter
    protected String schemaListFileName;
    @Parameter(defaultValue="false")
    protected boolean dtd;
    @Parameter(defaultValue="false")
    protected boolean npa;
    @Parameter(defaultValue="false")
    protected boolean nv;
    @Parameter(defaultValue="false")
    protected boolean relaxng;
    @Parameter(defaultValue="false")
    protected boolean relaxngCompact;
    @Parameter(defaultValue="false")
    protected boolean quiet;
    @Deprecated
    @Parameter(defaultValue="false")
    protected boolean readOnly;
    @Parameter(property="xjc.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="false")
    protected boolean wsdl;
    @Parameter(defaultValue="true")
    protected boolean xmlschema;
    @Parameter(defaultValue="false")
    protected boolean extension;
    @Parameter(defaultValue="false")
    protected boolean explicitAnnotation;
    @Parameter(property="xjc.arguments")
    protected String arguments;
    @Parameter
    protected String includeSchemasOutputPath;
    @Parameter(defaultValue="true")
    protected boolean clearOutputDir;
    @Parameter
    protected String target;
    @Parameter(defaultValue="true")
    protected boolean failOnNoSchemas;
    @Parameter(defaultValue="false")
    private boolean enableIntrospection;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Deprecated
    @Parameter
    private File staleFile;
    @Parameter(defaultValue="${project.build.directory}/jaxb2", readonly=true, required=true)
    private File staleFileDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            Package jaxbImplPackage = Driver.class.getPackage();
            this.getLog().debug((CharSequence)("Using XJC of " + jaxbImplPackage.getImplementationTitle() + " version " + jaxbImplPackage.getImplementationVersion()));
        }
        try {
            if (this.isOutputStale()) {
                this.getLog().info((CharSequence)"Generating source...");
                this.prepareDirectory(this.getOutputDirectory());
                if (this.generatedResourcesDirectory != null) {
                    this.prepareDirectory(this.generatedResourcesDirectory);
                }
                ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
                List<String> classpathFiles = this.getClasspathElements(this.project);
                ArrayList<URL> urls = new ArrayList<URL>(classpathFiles.size() + 1);
                StringBuilder classPath = new StringBuilder();
                for (String classpathFile : classpathFiles) {
                    this.getLog().debug((CharSequence)classpathFile);
                    urls.add(new File(classpathFile).toURI().toURL());
                    classPath.append(classpathFile);
                    classPath.append(File.pathSeparatorChar);
                }
                urls.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
                URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]), parent);
                Thread.currentThread().setContextClassLoader(cl);
                try {
                    ArrayList<String> args = this.getXJCArgs(classPath.toString());
                    MojoXjcListener xjcListener = new MojoXjcListener();
                    if (0 != Driver.run((String[])args.toArray(new String[args.size()]), (XJCListener)xjcListener)) {
                        String msg = "Could not process schema";
                        if (null != this.schemaFiles) {
                            URL[] xsds = this.getXSDFiles();
                            msg = msg + (xsds.length > 1 ? "s:" : ":");
                            for (int i = 0; i < xsds.length; ++i) {
                                msg = msg + "\n  " + xsds[i].getFile();
                            }
                        } else {
                            msg = msg + " files in directory " + this.getSchemaDirectory();
                        }
                        throw new MojoExecutionException(msg);
                    }
                    this.buildContext.refresh(this.getOutputDirectory());
                    this.touchStaleFile();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(parent);
                }
            } else {
                this.getLog().info((CharSequence)"No changes detected in schema or binding files - skipping source generation.");
            }
            this.addCompileSourceRoot(this.project);
            if (this.generatedResourcesDirectory != null) {
                Resource resource = new Resource();
                resource.setDirectory(this.generatedResourcesDirectory.getAbsolutePath());
                this.addResource(this.project, resource);
                this.buildContext.refresh(this.generatedResourcesDirectory);
            }
            if (this.includeSchemasOutputPath != null) {
                File includeSchemasOutputDirectory = new File(this.project.getBuild().getOutputDirectory(), this.includeSchemasOutputPath);
                FileUtils.forceMkdir((File)includeSchemasOutputDirectory);
                this.copyXSDs(includeSchemasOutputDirectory);
                this.buildContext.refresh(includeSchemasOutputDirectory);
            }
        }
        catch (NoSchemasException e) {
            if (this.failOnNoSchemas) {
                throw new MojoExecutionException("No schemas have been found");
            }
            this.getLog().warn((CharSequence)"Skipping xjc execution, no schemas have been found");
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected abstract void addCompileSourceRoot(MavenProject var1);

    protected abstract void addResource(MavenProject var1, Resource var2);

    protected void copyXSDs(File targetBaseDir) throws MojoExecutionException {
        URL[] srcFiles = this.getXSDFiles();
        for (int j = 0; j < srcFiles.length; ++j) {
            URL from = srcFiles[j];
            File to = new File(targetBaseDir, FileUtils.removePath((String)from.getPath(), (char)'/'));
            try {
                FileUtils.copyURLToFile((URL)from, (File)to);
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file", (Exception)e);
            }
        }
    }

    private void prepareDirectory(File dir) throws MojoExecutionException {
        if (this.clearOutputDir && dir.exists()) {
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error cleaning directory " + dir.getAbsolutePath(), (Exception)e);
            }
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + dir.getAbsolutePath());
        }
    }

    private ArrayList<String> getXJCArgs(String classPath) throws MojoExecutionException, NoSchemasException {
        File[] schemaFiles;
        ArrayList<String> args = new ArrayList<String>();
        if (this.npa) {
            args.add("-npa");
        }
        if (this.nv) {
            args.add("-nv");
        }
        if (this.dtd) {
            args.add("-dtd");
        }
        if (this.verbose) {
            args.add("-verbose");
        }
        if (this.quiet) {
            args.add("-quiet");
        }
        if (this.readOnly) {
            this.getLog().warn((CharSequence)"The readOnly parameter is deprecated. Support will be removed in a future version.");
            args.add("-readOnly");
        }
        if (this.relaxng) {
            args.add("-relaxng");
        }
        if (this.relaxngCompact) {
            args.add("-relaxng-compact");
        }
        if (this.wsdl) {
            args.add("-wsdl");
        }
        if (this.xmlschema) {
            args.add("-xmlschema");
        }
        if (this.explicitAnnotation) {
            args.add("-XexplicitAnnotation");
        }
        if (this.encoding != null && this.encoding.trim().length() > 0) {
            args.add("-encoding");
            args.add(this.encoding);
        } else {
            this.getLog().warn((CharSequence)"No encoding specified; default platform encoding will be used for generated sources.");
        }
        if (this.httpproxy != null) {
            args.add("-httpproxy");
            args.add(this.httpproxy);
        }
        if (this.packageName != null) {
            args.add("-p");
            args.add(this.packageName);
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (this.extension) {
            args.add("-extension");
        }
        if (this.target != null) {
            args.add("-target");
            args.add(this.target);
        }
        if (this.enableIntrospection) {
            args.add("-enableIntrospection");
        }
        if (this.arguments != null && this.arguments.trim().length() > 0) {
            try {
                String[] argList = CommandLineUtils.translateCommandline((String)this.arguments);
                for (int argIndex = 0; argIndex < argList.length; ++argIndex) {
                    args.add(argList[argIndex]);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("failed to split property arguments");
            }
        }
        args.add("-d");
        args.add(this.getOutputDirectory().getAbsolutePath());
        args.add("-classpath");
        args.add(classPath);
        File[] bindings = this.getBindingFiles();
        for (int i = 0; i < bindings.length; ++i) {
            args.add("-b");
            args.add(bindings[i].getAbsolutePath());
        }
        ArrayList<String> schemas = new ArrayList<String>();
        if (this.schemaFiles != null || this.schemaListFileName != null) {
            URL[] xsds = this.getXSDFiles();
            for (int i = 0; i < xsds.length; ++i) {
                schemas.add(xsds[i].toString());
            }
        } else if (this.getSchemaDirectory().exists() && this.getSchemaDirectory().isDirectory() && (schemaFiles = this.getSchemaDirectory().listFiles(new XSDFile(this.getLog()))) != null && schemaFiles.length > 0) {
            schemas.add(this.getSchemaDirectory().getAbsolutePath());
        }
        if (schemas.isEmpty()) {
            throw new NoSchemasException();
        }
        args.addAll(schemas);
        this.getLog().debug((CharSequence)("JAXB XJC args: " + args));
        return args;
    }

    protected void getSchemasFromFileListing(List<URL> files) throws MojoExecutionException {
        File schemaListFile = new File(this.schemaListFileName);
        Scanner scanner = null;
        try {
            scanner = new Scanner(schemaListFile).useDelimiter(",");
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("schemaListFileName: " + this.schemaListFileName + " could not be found - error:" + e.getMessage(), (Exception)e);
        }
        String nextToken = null;
        File nextFile = null;
        while (scanner.hasNext()) {
            URL url;
            nextToken = scanner.next();
            try {
                url = new URL(nextToken);
            }
            catch (MalformedURLException e) {
                this.getLog().debug((CharSequence)(nextToken + " doesn't look like a URL..."));
                nextFile = new File(this.getSchemaDirectory(), nextToken.trim());
                try {
                    url = nextFile.toURI().toURL();
                }
                catch (MalformedURLException e2) {
                    throw new MojoExecutionException("Unable to convert file to a URL.", (Exception)e2);
                }
            }
            files.add(url);
        }
    }

    public final File[] getBindingFiles() {
        ArrayList<File> bindings;
        block3: {
            block2: {
                bindings = new ArrayList<File>();
                if (this.bindingFiles == null) break block2;
                StringTokenizer st = new StringTokenizer(this.bindingFiles, ",");
                while (st.hasMoreTokens()) {
                    String schemaName = st.nextToken();
                    bindings.add(new File(this.getBindingDirectory(), schemaName));
                }
                break block3;
            }
            this.getLog().debug((CharSequence)("The binding Directory is " + this.getBindingDirectory()));
            File[] files = this.getBindingDirectory().listFiles(new XJBFile());
            if (files == null) break block3;
            for (int i = 0; i < files.length; ++i) {
                bindings.add(files[i]);
            }
        }
        return bindings.toArray(new File[0]);
    }

    public final URL[] getXSDFiles() throws MojoExecutionException {
        ArrayList<URL> xsdFiles;
        block10: {
            block11: {
                block9: {
                    if (this.schemaFiles != null && this.schemaListFileName != null) {
                        throw new MojoExecutionException("schemaFiles and schemaListFileName options were provided, these options may not be used together - schemaFiles: " + this.schemaFiles + "; schemaListFileName: " + this.schemaListFileName);
                    }
                    xsdFiles = new ArrayList<URL>();
                    if (this.schemaFiles == null) break block9;
                    DirectoryScanner scanner = new DirectoryScanner();
                    scanner.setBasedir(this.getSchemaDirectory());
                    scanner.setIncludes(this.schemaFiles.split(","));
                    scanner.scan();
                    for (String schemaName : scanner.getIncludedFiles()) {
                        URL url = null;
                        try {
                            url = new URL(schemaName.trim());
                        }
                        catch (MalformedURLException e) {
                            try {
                                url = new File(this.getSchemaDirectory(), schemaName).toURI().toURL();
                            }
                            catch (MalformedURLException e2) {
                                throw new MojoExecutionException("Unable to convert file to a URL.", (Exception)e2);
                            }
                        }
                        xsdFiles.add(url);
                    }
                    break block10;
                }
                if (this.schemaListFileName == null) break block11;
                this.getSchemasFromFileListing(xsdFiles);
                break block10;
            }
            this.getLog().debug((CharSequence)("The schema Directory is " + this.getSchemaDirectory()));
            File[] files = this.getSchemaDirectory().listFiles(new XSDFile(this.getLog()));
            if (files == null) break block10;
            for (int i = 0; i < files.length; ++i) {
                try {
                    xsdFiles.add(files[i].toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Unable to convert file to a URL.", (Exception)e);
                }
            }
        }
        return xsdFiles.toArray(new URL[xsdFiles.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOutputStale() throws MojoExecutionException {
        boolean stale;
        URL[] sourceXsds = this.getXSDFiles();
        File[] sourceXjbs = this.getBindingFiles();
        boolean bl = stale = !this.getStaleFile().exists();
        if (!stale) {
            int i;
            this.getLog().debug((CharSequence)"Stale flag file exists, comparing to xsds and xjbs.");
            long staleMod = this.getStaleFile().lastModified();
            for (i = 0; i < sourceXsds.length; ++i) {
                URLConnection connection;
                try {
                    connection = sourceXsds[i].openConnection();
                    connection.connect();
                }
                catch (IOException e) {
                    stale = true;
                    break;
                }
                try {
                    if (connection.getLastModified() <= staleMod) continue;
                    this.getLog().debug((CharSequence)(sourceXsds[i].toString() + " is newer than the stale flag file."));
                    stale = true;
                    break;
                }
                finally {
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).disconnect();
                    }
                }
            }
            for (i = 0; i < sourceXjbs.length; ++i) {
                if (sourceXjbs[i].lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceXjbs[i].getName() + " is newer than the stale flag file."));
                stale = true;
                break;
            }
        }
        return stale;
    }

    private void touchStaleFile() throws IOException {
        if (!this.getStaleFile().exists()) {
            this.getStaleFile().getParentFile().mkdirs();
            this.getStaleFile().createNewFile();
            this.getLog().debug((CharSequence)"Stale flag file created.");
        } else {
            this.getStaleFile().setLastModified(System.currentTimeMillis());
        }
    }

    private File getStaleFile() {
        if (this.staleFile != null) {
            this.getLog().info((CharSequence)"Deprecated staleFile parameter configuration found - please remove!");
            return this.staleFile;
        }
        return new File(this.staleFileDirectory, "." + this.execution.getExecutionId() + "-" + this.getStaleFileExtensionSuffix());
    }

    protected abstract String getStaleFileExtensionSuffix();

    protected abstract File getOutputDirectory();

    protected abstract File getSchemaDirectory();

    protected abstract File getBindingDirectory();

    protected abstract List<String> getClasspathElements(MavenProject var1) throws DependencyResolutionRequiredException;

    class MojoXjcListener
    extends XJCListener {
        List<String> files = new ArrayList<String>();

        MojoXjcListener() {
        }

        private String location(SAXParseException e) {
            return StringUtils.defaultString((Object)e.getPublicId(), (String)e.getSystemId()) + "[" + e.getLineNumber() + "," + e.getColumnNumber() + "]";
        }

        public void error(SAXParseException arg0) {
            AbstractXjcMojo.this.getLog().error((CharSequence)this.location(arg0), (Throwable)arg0);
        }

        public void fatalError(SAXParseException arg0) {
            AbstractXjcMojo.this.getLog().error((CharSequence)this.location(arg0), (Throwable)arg0);
        }

        public void warning(SAXParseException arg0) {
            AbstractXjcMojo.this.getLog().warn((CharSequence)this.location(arg0), (Throwable)arg0);
        }

        public void info(SAXParseException arg0) {
            AbstractXjcMojo.this.getLog().warn((CharSequence)this.location(arg0), (Throwable)arg0);
        }

        public void message(String arg0) {
            AbstractXjcMojo.this.getLog().info((CharSequence)arg0);
        }

        public void generatedFile(String arg0) {
            AbstractXjcMojo.this.getLog().info((CharSequence)arg0);
            this.files.add(arg0);
        }
    }

    final class XSDFile
    implements FileFilter {
        private Log log;

        public XSDFile(Log log) {
            this.log = log;
        }

        @Override
        public boolean accept(File file) {
            boolean accept;
            boolean bl = accept = file.isFile() && file.getName().endsWith(".xsd");
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("accept " + accept + " for file " + file.getPath()));
            }
            return accept;
        }
    }

    final class XJBFile
    implements FileFilter {
        XJBFile() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".xjb");
        }
    }
}

