/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.RevEngUtils;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.sql.Alias;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeyProcessor {
    private static final Logger log = LoggerFactory.getLogger(PrimaryKeyProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processPrimaryKey(MetaDataDialect metaDataDialect, ReverseEngineeringStrategy revengStrategy, String defaultSchema, String defaultCatalog, DatabaseCollector dbs, Table table) {
        ArrayList<Object> columns = new ArrayList<Object[]>();
        PrimaryKey key = null;
        Iterator<Map<String, Object>> primaryKeyIterator = null;
        try {
            Map<String, Object> primaryKeyRs = null;
            primaryKeyIterator = metaDataDialect.getPrimaryKeys(PrimaryKeyProcessor.getCatalogForDBLookup(table.getCatalog(), defaultCatalog), PrimaryKeyProcessor.getSchemaForDBLookup(table.getSchema(), defaultSchema), table.getName());
            while (primaryKeyIterator.hasNext()) {
                primaryKeyRs = primaryKeyIterator.next();
                String columnName = (String)primaryKeyRs.get("COLUMN_NAME");
                short seq = (Short)primaryKeyRs.get("KEY_SEQ");
                String string = (String)primaryKeyRs.get("PK_NAME");
                if (key == null) {
                    key = new PrimaryKey();
                    key.setName(string);
                    key.setTable(table);
                    if (table.getPrimaryKey() != null) {
                        throw new JDBCBinderException(table + " already has a primary key!");
                    }
                    table.setPrimaryKey(key);
                } else if (string != key.getName() && string != null && !string.equals(key.getName())) {
                    throw new JDBCBinderException("Duplicate names found for primarykey. Existing name: " + key.getName() + " JDBC name: " + string + " on table " + table);
                }
                columns.add(new Object[]{new Short(seq), columnName});
            }
        }
        finally {
            if (primaryKeyIterator != null) {
                try {
                    metaDataDialect.close(primaryKeyIterator);
                }
                catch (JDBCException se) {
                    log.warn("Exception when closing resultset for reading primary key information", (Throwable)se);
                }
            }
        }
        Collections.sort(columns, new Comparator(){

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }

            public int compare(Object o1, Object o2) {
                Short left = (Short)((Object[])o1)[0];
                Short right = (Short)((Object[])o2)[0];
                return left.compareTo(right);
            }

            public int hashCode() {
                return super.hashCode();
            }
        });
        ArrayList<Object> t = new ArrayList<Object>(columns.size());
        for (Object[] element : columns) {
            t.add(element[1]);
        }
        columns = t;
        if (key == null) {
            log.warn("The JDBC driver didn't report any primary key columns in " + table.getName() + ". Asking rev.eng. strategy");
            List<String> userPrimaryKey = RevEngUtils.getPrimaryKeyInfoInRevengStrategy(revengStrategy, table, defaultCatalog, defaultSchema);
            if (userPrimaryKey != null && !userPrimaryKey.isEmpty()) {
                key = new PrimaryKey();
                key.setName(new Alias(15, "PK").toAliasString(table.getName()));
                key.setTable(table);
                if (table.getPrimaryKey() != null) {
                    throw new JDBCBinderException(table + " already has a primary key!");
                }
                table.setPrimaryKey(key);
                columns = new ArrayList<String>(userPrimaryKey);
            } else {
                log.warn("Rev.eng. strategy did not report any primary key columns for " + table.getName());
            }
        }
        Iterator suggestedPrimaryKeyStrategyName = metaDataDialect.getSuggestedPrimaryKeyStrategyName(PrimaryKeyProcessor.getCatalogForDBLookup(table.getCatalog(), defaultCatalog), PrimaryKeyProcessor.getSchemaForDBLookup(table.getSchema(), defaultSchema), table.getName());
        try {
            Map map;
            String suggestion;
            if (suggestedPrimaryKeyStrategyName.hasNext() && (suggestion = (String)(map = (Map)suggestedPrimaryKeyStrategyName.next()).get("HIBERNATE_STRATEGY")) != null) {
                dbs.addSuggestedIdentifierStrategy(table.getCatalog(), table.getSchema(), table.getName(), suggestion);
            }
        }
        finally {
            if (suggestedPrimaryKeyStrategyName != null) {
                try {
                    metaDataDialect.close(suggestedPrimaryKeyStrategyName);
                }
                catch (JDBCException jDBCException) {
                    log.warn("Exception while closing iterator for suggested primary key strategy name", (Throwable)jDBCException);
                }
            }
        }
        if (key != null) {
            for (String string : columns) {
                Column col = PrimaryKeyProcessor.getColumn(metaDataDialect, table, string);
                key.addColumn(col);
            }
            log.debug("primary key for " + table + " -> " + key);
        }
    }

    private static String getCatalogForDBLookup(String catalog, String defaultCatalog) {
        return catalog == null ? defaultCatalog : catalog;
    }

    private static String getSchemaForDBLookup(String schema, String defaultSchema) {
        return schema == null ? defaultSchema : schema;
    }

    private static Column getColumn(MetaDataDialect metaDataDialect, Table table, String columnName) {
        Column column = new Column();
        column.setName(PrimaryKeyProcessor.quote(metaDataDialect, columnName));
        Column existing = table.getColumn(column);
        if (existing != null) {
            column = existing;
        }
        return column;
    }

    private static String quote(MetaDataDialect metaDataDialect, String columnName) {
        if (columnName == null) {
            return columnName;
        }
        if (metaDataDialect.needQuote(columnName)) {
            if (columnName.length() > 1 && columnName.charAt(0) == '`' && columnName.charAt(columnName.length() - 1) == '`') {
                return columnName;
            }
            return "`" + columnName + "`";
        }
        return columnName;
    }
}

