/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Binding;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Binding"})
public class RubyBinding
extends RubyObject {
    private Binding binding;
    private static ObjectAllocator BINDING_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyBinding instance = new RubyBinding(runtime2, klass);
            return instance;
        }
    };

    public RubyBinding(Ruby runtime2, RubyClass rubyClass, Binding binding2) {
        super(runtime2, rubyClass);
        this.binding = binding2;
    }

    private RubyBinding(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public static RubyClass createBindingClass(Ruby runtime2) {
        RubyClass bindingClass = runtime2.defineClass("Binding", runtime2.getObject(), BINDING_ALLOCATOR);
        runtime2.setBinding(bindingClass);
        bindingClass.defineAnnotatedMethods(RubyBinding.class);
        bindingClass.getSingletonClass().undefineMethod("new");
        return bindingClass;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public static RubyBinding newBinding(Ruby runtime2, Binding binding2) {
        return new RubyBinding(runtime2, runtime2.getBinding(), binding2);
    }

    @Deprecated
    public static RubyBinding newBinding(Ruby runtime2) {
        return RubyBinding.newBinding(runtime2, runtime2.getCurrentContext().currentBinding());
    }

    @Deprecated
    public static RubyBinding newBinding(Ruby runtime2, IRubyObject self) {
        return RubyBinding.newBinding(runtime2, runtime2.getCurrentContext().currentBinding(self));
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        this.binding = context.currentBinding();
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject other) {
        RubyBinding otherBinding = (RubyBinding)other;
        this.binding = otherBinding.binding;
        return this;
    }
}

