/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;

@JRubyModule(name={"Marshal"})
public class RubyMarshal {
    public static RubyModule createMarshalModule(Ruby runtime2) {
        RubyModule module = runtime2.defineModule("Marshal");
        runtime2.setMarshal(module);
        module.defineAnnotatedMethods(RubyMarshal.class);
        module.defineConstant("MAJOR_VERSION", runtime2.newFixnum(4));
        module.defineConstant("MINOR_VERSION", runtime2.newFixnum(8));
        return module;
    }

    @JRubyMethod(name={"dump"}, required=1, optional=2, frame=true, module=true)
    public static IRubyObject dump(IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        if (args2.length < 1) {
            throw recv2.getRuntime().newArgumentError("wrong # of arguments(at least 1)");
        }
        IRubyObject objectToDump = args2[0];
        IRubyObject io2 = null;
        int depthLimit = -1;
        if (args2.length >= 2) {
            if (args2[1].respondsTo("write")) {
                io2 = args2[1];
            } else if (args2[1] instanceof RubyFixnum) {
                depthLimit = (int)((RubyFixnum)args2[1]).getLongValue();
            } else {
                throw recv2.getRuntime().newTypeError("Instance of IO needed");
            }
            if (args2.length == 3) {
                depthLimit = (int)((RubyFixnum)args2[2]).getLongValue();
            }
        }
        try {
            if (io2 != null) {
                RubyMarshal.dumpToStream(objectToDump, RubyMarshal.outputStream(io2), depthLimit);
                return io2;
            }
            ByteArrayOutputStream stringOutput = new ByteArrayOutputStream();
            RubyMarshal.dumpToStream(objectToDump, stringOutput, depthLimit);
            return RubyString.newString(recv2.getRuntime(), new ByteList(stringOutput.toByteArray(), false));
        }
        catch (IOException ioe) {
            throw recv2.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static OutputStream outputStream(IRubyObject out) {
        RubyMarshal.setBinmodeIfPossible(out);
        if (out instanceof RubyIO) {
            return ((RubyIO)out).getOutStream();
        }
        return new IOOutputStream(out);
    }

    private static void setBinmodeIfPossible(IRubyObject io2) {
        if (io2.respondsTo("binmode")) {
            io2.callMethod(io2.getRuntime().getCurrentContext(), "binmode");
        }
    }

    @JRubyMethod(name={"load", "restore"}, required=1, optional=1, frame=true, module=true)
    public static IRubyObject load(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        try {
            InputStream rawInput;
            if (args2.length < 1) {
                throw recv2.getRuntime().newArgumentError("wrong number of arguments (0 for 1)");
            }
            if (args2.length > 2) {
                throw recv2.getRuntime().newArgumentError("wrong number of arguments (" + args2.length + " for 2)");
            }
            IRubyObject in = null;
            IRubyObject proc2 = null;
            switch (args2.length) {
                case 2: {
                    proc2 = args2[1];
                }
                case 1: {
                    in = args2[0];
                }
            }
            if (in != null && in.respondsTo("read")) {
                rawInput = RubyMarshal.inputStream(in);
            } else if (in != null && in.respondsTo("to_str")) {
                RubyString inString = (RubyString)RuntimeHelpers.invoke(context, in, "to_str");
                ByteList bytes2 = inString.getByteList();
                rawInput = new ByteArrayInputStream(bytes2.unsafeBytes(), bytes2.begin(), bytes2.length());
            } else {
                throw recv2.getRuntime().newTypeError("instance of IO needed");
            }
            UnmarshalStream input = new UnmarshalStream(recv2.getRuntime(), rawInput, proc2);
            return input.unmarshalObject();
        }
        catch (EOFException ee) {
            throw recv2.getRuntime().newEOFError();
        }
        catch (IOException ioe) {
            throw recv2.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static InputStream inputStream(IRubyObject in) {
        RubyMarshal.setBinmodeIfPossible(in);
        if (in instanceof RubyIO) {
            return ((RubyIO)in).getInStream();
        }
        return new IOInputStream(in);
    }

    private static void dumpToStream(IRubyObject object, OutputStream rawOutput, int depthLimit) throws IOException {
        MarshalStream output = new MarshalStream(object.getRuntime(), rawOutput, depthLimit);
        output.dumpObject(object);
    }
}

