/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"Tempfile"}, parent="File")
public class RubyTempfile
extends RubyFile {
    private static ObjectAllocator TEMPFILE_ALLOCATOR;
    private static final String DEFAULT_TMP_DIR;
    private static final Object tmpFileLock;
    private static int counter;
    private File tmpFile = null;

    public static RubyClass createTempfileClass(Ruby runtime2) {
        RubyClass tempfileClass = runtime2.defineClass("Tempfile", runtime2.getFile(), TEMPFILE_ALLOCATOR);
        RubyKernel.require(tempfileClass, runtime2.newString("tmpdir"), Block.NULL_BLOCK);
        tempfileClass.defineAnnotatedMethods(RubyTempfile.class);
        return tempfileClass;
    }

    public RubyTempfile(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(required=1, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        Ruby runtime2 = this.getRuntime();
        IRubyObject basename2 = args2[0];
        IRubyObject dir = this.defaultTmpDir(runtime2, args2);
        File tmp = null;
        Object object = tmpFileLock;
        synchronized (object) {
            try {
                IRubyObject tmpname;
                do {
                    if (counter == -1) {
                        counter = new Random().nextInt() & 0xFFFF;
                    }
                    tmpname = this.callMethod(runtime2.getCurrentContext(), "make_tmpname", new IRubyObject[]{basename2, runtime2.newFixnum(++counter)});
                } while (!(tmp = new File(dir.convertToString().toString(), tmpname.convertToString().toString())).createNewFile());
                this.tmpFile = tmp;
                this.path = tmp.getPath();
                this.tmpFile.deleteOnExit();
                this.initializeOpen();
                return this;
            }
            catch (IOException e) {
                throw runtime2.newIOErrorFromException(e);
            }
        }
    }

    private IRubyObject defaultTmpDir(Ruby runtime2, IRubyObject[] args2) {
        IRubyObject dir = null;
        if (args2.length == 2) {
            dir = args2[1];
        } else {
            runtime2.getLoadService().require("tmpdir");
            dir = runtime2.getDir().callMethod(runtime2.getCurrentContext(), "tmpdir");
        }
        if (runtime2.getSafeLevel() > 0 && dir.isTaint()) {
            dir = runtime2.newString(DEFAULT_TMP_DIR);
        }
        return dir;
    }

    private void initializeOpen() {
        try {
            ModeFlags modeFlags = new ModeFlags(ModeFlags.RDWR | ModeFlags.EXCL);
            this.getRuntime().getPosix().chmod(this.path, 384);
            this.sysopenInternal(this.path, modeFlags, 384);
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
    }

    @JRubyMethod(frame=true, required=2, visibility=Visibility.PRIVATE)
    public IRubyObject make_tmpname(ThreadContext context, IRubyObject basename2, IRubyObject n, Block block) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject[] newargs = new IRubyObject[]{runtime2.newString("%s.%d.%d"), basename2, runtime2.getGlobalVariables().get("$$"), n};
        return this.callMethod(context, "sprintf", newargs);
    }

    @JRubyMethod(frame=true, visibility=Visibility.PUBLIC)
    public IRubyObject open() {
        if (!this.isClosed()) {
            this.close();
        }
        try {
            this.openInternal(this.path, "r+");
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    @JRubyMethod(frame=true, visibility=Visibility.PROTECTED)
    public IRubyObject _close(ThreadContext context) {
        return !this.isClosed() ? super.close() : context.getRuntime().getNil();
    }

    @JRubyMethod(optional=1, frame=true, visibility=Visibility.PUBLIC)
    public IRubyObject close(ThreadContext context, IRubyObject[] args2, Block block) {
        boolean unlink2 = args2.length == 1 ? args2[0].isTrue() : false;
        return unlink2 ? this.close_bang(context) : this._close(context);
    }

    @JRubyMethod(name={"close!"}, frame=true, visibility=Visibility.PUBLIC)
    public IRubyObject close_bang(ThreadContext context) {
        this._close(context);
        this.tmpFile.delete();
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"unlink", "delete"}, frame=true)
    public IRubyObject unlink(ThreadContext context) {
        if (this.tmpFile.exists()) {
            this.tmpFile.delete();
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"size", "length"}, frame=true)
    public IRubyObject size(ThreadContext context) {
        if (!this.isClosed()) {
            this.flush();
            return context.getRuntime().newFileStat(this.path, false).size();
        }
        return RubyFixnum.zero(context.getRuntime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyClass klass = (RubyClass)recv2;
        RubyTempfile tempfile = (RubyTempfile)klass.newInstance(context, args2, block);
        if (block.isGiven()) {
            try {
                block.yield(context, tempfile);
            }
            finally {
                if (!tempfile.isClosed()) {
                    tempfile.close();
                }
            }
            return runtime2.getNil();
        }
        return tempfile;
    }

    static {
        String tmpDir;
        TEMPFILE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                RubyTempfile instance = new RubyTempfile(runtime2, klass);
                instance.setMetaClass(klass);
                return instance;
            }
        };
        tmpFileLock = new Object();
        counter = -1;
        if (Platform.IS_WINDOWS) {
            tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                tmpDir = System.getenv("TEMP");
            }
            if (tmpDir == null) {
                tmpDir = System.getenv("TMP");
            }
            if (tmpDir == null) {
                tmpDir = "C:\\Windows\\Temp";
            }
        } else {
            tmpDir = "/tmp";
        }
        DEFAULT_TMP_DIR = tmpDir;
    }
}

