/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Interpreted19Block;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterNode
extends Node {
    private final Node varNode;
    private final Node bodyNode;
    private StaticScope scope;
    private BlockBody blockBody;

    public IterNode(ISourcePosition position, Node varNode, StaticScope scope, Node bodyNode) {
        super(position);
        this.varNode = varNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(this);
        this.blockBody = new InterpretedBlock(this, Arity.procArityOf(varNode), BlockBody.asArgumentType(argsNodeId));
    }

    public IterNode(ISourcePosition position, ArgsNode args2, Node body, StaticScope scope) {
        super(position);
        this.varNode = args2;
        this.bodyNode = body;
        this.scope = scope;
        this.blockBody = new Interpreted19Block(this);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ITERNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getVarNode() {
        return this.varNode;
    }

    public BlockBody getBlockBody() {
        return this.blockBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.varNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        assert (false) : "Call nodes deal with these directly";
        return null;
    }
}

