/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ClassCache;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public class JITCompiler
implements JITCompilerMBean {
    public static final boolean USE_CACHE = true;
    private AtomicLong compiledCount = new AtomicLong(0L);
    private AtomicLong successCount = new AtomicLong(0L);
    private AtomicLong failCount = new AtomicLong(0L);
    private AtomicLong abandonCount = new AtomicLong(0L);
    private AtomicLong compileTime = new AtomicLong(0L);
    private AtomicLong averageCompileTime = new AtomicLong(0L);
    private AtomicLong codeSize = new AtomicLong(0L);
    private AtomicLong averageCodeSize = new AtomicLong(0L);
    private AtomicLong largestCodeSize = new AtomicLong(0L);

    public JITCompiler(Ruby ruby) {
        ruby.getBeanManager().register(this);
    }

    public DynamicMethod tryJIT(DefaultMethod method2, ThreadContext context, String name2) {
        if (context.getRuntime().getInstanceConfig().getCompileMode().shouldJIT()) {
            return this.jitIsEnabled(method2, context, name2);
        }
        return null;
    }

    @Deprecated
    public void runJIT(DefaultMethod method2, ThreadContext context, String name2) {
        if (method2.getCallCount() < 0) {
            return;
        }
        this.jitIsEnabled(method2, context, name2);
    }

    private DynamicMethod jitIsEnabled(DefaultMethod method2, ThreadContext context, String name2) {
        RubyInstanceConfig instanceConfig = context.getRuntime().getInstanceConfig();
        if (method2.incrementCallCount() >= instanceConfig.getJitThreshold()) {
            return this.jitThresholdReached(method2, instanceConfig, context, name2);
        }
        return null;
    }

    private DynamicMethod jitThresholdReached(DefaultMethod method2, RubyInstanceConfig instanceConfig, ThreadContext context, String name2) {
        try {
            int methodCount;
            ClassCache classCache = instanceConfig.getClassCache();
            if (classCache.isFull()) {
                this.abandonCount.incrementAndGet();
                method2.setCallCount(-1);
                return null;
            }
            String moduleName = method2.getImplementationClass().getName();
            if (instanceConfig.getExcludedMethods().size() > 0 && (instanceConfig.getExcludedMethods().contains(moduleName) || instanceConfig.getExcludedMethods().contains(moduleName + "#" + name2) || instanceConfig.getExcludedMethods().contains(name2))) {
                method2.setCallCount(-1);
                return null;
            }
            JITClassGenerator generator = new JITClassGenerator(name2, context.getRuntime(), method2, context);
            String key2 = SexpMaker.create(name2, method2.getArgsNode(), method2.getBodyNode());
            Class sourceClass = instanceConfig.getClassCache().cacheClassByKey(key2, generator);
            if (sourceClass == null) {
                this.failCount.incrementAndGet();
                method2.setCallCount(-1);
                return null;
            }
            this.successCount.incrementAndGet();
            Script jitCompiledScript = (Script)sourceClass.newInstance();
            Set<Script> jittedMethods = context.getRuntime().getJittedMethods();
            jittedMethods.add(jitCompiledScript);
            if (instanceConfig.getJitLogEvery() > 0 && (methodCount = jittedMethods.size()) % instanceConfig.getJitLogEvery() == 0) {
                JITCompiler.log(method2, name2, "live compiled methods: " + methodCount, new String[0]);
            }
            if (instanceConfig.isJitLogging()) {
                JITCompiler.log(method2, name2, "done jitting", new String[0]);
            }
            method2.switchToJitted(jitCompiledScript, generator.callConfig());
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (instanceConfig.isJitLoggingVerbose()) {
                JITCompiler.log(method2, name2, "could not compile", t.getMessage());
            }
            this.failCount.incrementAndGet();
            method2.setCallCount(-1);
            return null;
        }
    }

    private static String calculateFilename(ArgsNode argsNode, Node bodyNode) {
        if (bodyNode != null) {
            return bodyNode.getPosition().getFile();
        }
        if (argsNode != null) {
            return argsNode.getPosition().getFile();
        }
        return "__eval__";
    }

    static void log(DefaultMethod method2, String name2, String message2, String ... reason2) {
        String className = method2.getImplementationClass().getBaseName();
        if (className == null) {
            className = "<anon class>";
        }
        System.err.print(message2 + ":" + className + "." + name2);
        if (reason2.length > 0) {
            System.err.print(" because of: \"");
            for (int i = 0; i < reason2.length; ++i) {
                System.err.print(reason2[i]);
            }
            System.err.print('\"');
        }
        System.err.println("");
    }

    public long getSuccessCount() {
        return this.successCount.get();
    }

    public long getCompileCount() {
        return this.compiledCount.get();
    }

    public long getFailCount() {
        return this.failCount.get();
    }

    public long getCompileTime() {
        return this.compileTime.get() / 1000L;
    }

    public long getAbandonCount() {
        return this.abandonCount.get();
    }

    public long getCodeSize() {
        return this.codeSize.get();
    }

    public long getAverageCodeSize() {
        return this.averageCodeSize.get();
    }

    public long getAverageCompileTime() {
        return this.averageCompileTime.get() / 1000L;
    }

    public long getLargestCodeSize() {
        return this.largestCodeSize.get();
    }

    public class JITClassGenerator
    implements ClassCache.ClassGenerator {
        private StandardASMCompiler asmCompiler;
        private DefaultMethod method;
        private StaticScope staticScope;
        private Node bodyNode;
        private ArgsNode argsNode;
        private CallConfiguration jitCallConfig;
        private byte[] bytecode;
        private String name;
        private Ruby ruby;

        public JITClassGenerator(String name2, Ruby ruby, DefaultMethod method2, ThreadContext context) {
            this.method = method2;
            String packageName = "ruby/jit/" + JavaNameMangler.mangleFilenameForClasspath(method2.getPosition().getFile());
            String cleanName = packageName + "/" + JavaNameMangler.mangleStringForCleanJavaIdentifier(name2);
            this.bodyNode = method2.getBodyNode();
            this.argsNode = method2.getArgsNode();
            String filename2 = JITCompiler.calculateFilename(this.argsNode, this.bodyNode);
            this.staticScope = method2.getStaticScope();
            this.asmCompiler = new StandardASMCompiler(cleanName + method2.hashCode() + "_" + context.hashCode(), filename2);
            this.ruby = ruby;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compile() {
            BodyCompiler methodCompiler;
            if (this.bytecode != null) {
                return;
            }
            long start2 = System.nanoTime();
            this.asmCompiler.startScript(this.staticScope);
            final ASTCompiler compiler = this.ruby.getInstanceConfig().newCompiler();
            CompilerCallback args2 = new CompilerCallback(){

                public void call(BodyCompiler context) {
                    compiler.compileArgs(JITClassGenerator.this.argsNode, context, true);
                }
            };
            ASTInspector inspector = new ASTInspector();
            inspector.inspect(this.argsNode);
            inspector.inspect(this.bodyNode);
            if (this.bodyNode != null) {
                methodCompiler = this.asmCompiler.startMethod("__file__", "__file__", args2, this.staticScope, inspector);
                compiler.compile(this.bodyNode, methodCompiler, true);
            } else if (this.argsNode != null && (this.argsNode.getRequiredArgsCount() > 0 || this.argsNode.getOptionalArgsCount() > 0)) {
                methodCompiler = this.asmCompiler.startMethod("__file__", "__file__", args2, this.staticScope, inspector);
                methodCompiler.loadNil();
            } else {
                methodCompiler = this.asmCompiler.startMethod("__file__", "__file__", null, this.staticScope, inspector);
                methodCompiler.loadNil();
                this.jitCallConfig = CallConfiguration.FrameNoneScopeNone;
            }
            methodCompiler.endBody();
            this.asmCompiler.endScript(false, false);
            if (this.jitCallConfig == null) {
                this.jitCallConfig = inspector.getCallConfig();
            }
            this.bytecode = this.asmCompiler.getClassByteArray();
            this.name = CodegenUtils.c(this.asmCompiler.getClassname());
            if (this.bytecode.length > this.ruby.getInstanceConfig().getJitMaxSize()) {
                this.bytecode = null;
                throw new NotCompilableException("JITed method size exceeds configured max of " + this.ruby.getInstanceConfig().getJitMaxSize());
            }
            JITCompiler.this.compiledCount.incrementAndGet();
            JITCompiler.this.compileTime.addAndGet(System.nanoTime() - start2);
            JITCompiler.this.codeSize.addAndGet(this.bytecode.length);
            JITCompiler.this.averageCompileTime.set(JITCompiler.this.compileTime.get() / JITCompiler.this.compiledCount.get());
            JITCompiler.this.averageCodeSize.set(JITCompiler.this.codeSize.get() / JITCompiler.this.compiledCount.get());
            AtomicLong atomicLong = JITCompiler.this.largestCodeSize;
            synchronized (atomicLong) {
                if (JITCompiler.this.largestCodeSize.get() < (long)this.bytecode.length) {
                    JITCompiler.this.largestCodeSize.set(this.bytecode.length);
                }
            }
        }

        public byte[] bytecode() {
            this.compile();
            return this.bytecode;
        }

        public String name() {
            this.compile();
            return this.name;
        }

        public CallConfiguration callConfig() {
            this.compile();
            return this.jitCallConfig;
        }
    }
}

