/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.Library;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.jffi.DefaultMethodFactory;
import org.jruby.ext.ffi.jffi.DynamicLibrary;
import org.jruby.ext.ffi.jffi.FunctionInvoker;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::VariadicInvoker"}, parent="Object")
public class VariadicInvoker
extends RubyObject {
    private final CallingConvention convention;
    private final Library library;
    private final long address;
    private final FunctionInvoker functionInvoker;
    private final Type returnType;

    public static RubyClass createVariadicInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("VariadicInvoker", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(VariadicInvoker.class);
        result.defineAnnotatedConstants(VariadicInvoker.class);
        return result;
    }

    private VariadicInvoker(Ruby runtime2, IRubyObject klazz, Library library2, long address2, FunctionInvoker functionInvoker, Type returnType, CallingConvention convention) {
        super(runtime2, (RubyClass)klazz);
        this.library = library2;
        this.address = address2;
        this.functionInvoker = functionInvoker;
        this.returnType = returnType;
        this.convention = convention;
    }

    public final Arity getArity() {
        return Arity.OPTIONAL;
    }

    @JRubyMethod(name={"__new"}, meta=true, required=4)
    public static VariadicInvoker newInvoker(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long address2;
        Library library2;
        CallingConvention conv2 = "stdcall".equals(args2[3].toString()) ? CallingConvention.STDCALL : CallingConvention.STDCALL;
        try {
            library2 = args2[0] instanceof DynamicLibrary ? ((DynamicLibrary)args2[0]).getNativeLibrary() : Library.getCachedInstance(args2[0].toString(), 1);
            address2 = args2[1] instanceof DynamicLibrary.Symbol ? ((DynamicLibrary.Symbol)args2[1]).getAddress() : library2.getSymbolAddress(args2[1].toString());
        }
        catch (UnsatisfiedLinkError ex) {
            throw context.getRuntime().newLoadError(ex.getMessage());
        }
        NativeType returnType = NativeType.valueOf(args2[2]);
        FunctionInvoker functionInvoker = DefaultMethodFactory.getFunctionInvoker(returnType);
        return new VariadicInvoker(recv2.getRuntime(), recv2, library2, address2, functionInvoker, VariadicInvoker.getFFIType(returnType), conv2);
    }

    @JRubyMethod(name={"invoke"})
    public IRubyObject invoke(ThreadContext context, IRubyObject typesArg, IRubyObject paramsArg) {
        IRubyObject[] types = ((RubyArray)typesArg).toJavaArrayMaybeUnsafe();
        IRubyObject[] params2 = ((RubyArray)paramsArg).toJavaArrayMaybeUnsafe();
        Type[] ffiParamTypes = new Type[types.length];
        NativeType[] paramTypes = new NativeType[types.length];
        for (int i = 0; i < types.length; ++i) {
            NativeType t = NativeType.valueOf(types[i]);
            switch (t) {
                case INT8: 
                case INT16: 
                case INT32: {
                    paramTypes[i] = NativeType.INT32;
                    break;
                }
                case UINT8: 
                case UINT16: 
                case UINT32: {
                    paramTypes[i] = NativeType.UINT32;
                    break;
                }
                case FLOAT32: 
                case FLOAT64: {
                    paramTypes[i] = NativeType.FLOAT64;
                    break;
                }
                default: {
                    paramTypes[i] = t;
                }
            }
            ffiParamTypes[i] = VariadicInvoker.getFFIType(paramTypes[i]);
        }
        Invocation invocation = new Invocation(context);
        Function function = new Function(this.address, this.returnType, ffiParamTypes, this.convention);
        HeapInvocationBuffer args2 = new HeapInvocationBuffer(function);
        for (int i = 0; i < types.length; ++i) {
            DefaultMethodFactory.getMarshaller(paramTypes[i]).marshal(invocation, (InvocationBuffer)args2, params2[i]);
        }
        return this.functionInvoker.invoke(context.getRuntime(), function, args2);
    }

    private static final Type getFFIType(NativeParam type2) {
        if (type2 instanceof NativeType) {
            switch ((NativeType)type2) {
                case VOID: {
                    return Type.VOID;
                }
                case INT8: {
                    return Type.SINT8;
                }
                case UINT8: {
                    return Type.UINT8;
                }
                case INT16: {
                    return Type.SINT16;
                }
                case UINT16: {
                    return Type.UINT16;
                }
                case INT32: {
                    return Type.SINT32;
                }
                case UINT32: {
                    return Type.UINT32;
                }
                case INT64: {
                    return Type.SINT64;
                }
                case UINT64: {
                    return Type.UINT64;
                }
                case LONG: {
                    return Platform.getPlatform().addressSize() == 32 ? Type.SINT32 : Type.SINT64;
                }
                case ULONG: {
                    return Platform.getPlatform().addressSize() == 32 ? Type.UINT32 : Type.UINT64;
                }
                case FLOAT32: {
                    return Type.FLOAT;
                }
                case FLOAT64: {
                    return Type.DOUBLE;
                }
                case POINTER: {
                    return Type.POINTER;
                }
                case BUFFER_IN: 
                case BUFFER_OUT: 
                case BUFFER_INOUT: {
                    return Type.POINTER;
                }
                case STRING: {
                    return Type.POINTER;
                }
            }
            throw new IllegalArgumentException("Unknown type " + type2);
        }
        throw new IllegalArgumentException("Unknown type " + type2);
    }
}

