/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

@Deprecated
public class IntHashMap {
    private transient Entry[] table;
    private transient int count;
    volatile transient Set keySet = null;
    volatile transient Collection values = null;
    private int threshold;
    private final float loadFactor;
    private transient Set entrySet = null;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value.equals(value2)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value2) {
        return this.contains(value2);
    }

    public boolean containsKey(int key2) {
        Entry[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        while (e != null) {
            if (e.hash == hash2) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(int key2) {
        Entry[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        while (e != null) {
            if (e.hash == hash2) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index2 = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index2];
                newMap[index2] = e;
            }
        }
    }

    Entry getEntry(int key2) {
        Entry[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        while (e != null) {
            if (e.hash == hash2) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public Object put(int key2, Object value2) {
        Entry[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        while (e != null) {
            if (e.hash == hash2) {
                Object old = e.value;
                e.value = value2;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        }
        tab[index2] = e = new Entry(hash2, key2, value2, tab[index2]);
        ++this.count;
        return null;
    }

    public Object remove(int key2) {
        Entry[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash2) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index2] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        int index2 = tab.length;
        while (--index2 >= 0) {
            tab[index2] = null;
        }
        this.count = 0;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return IntHashMap.this.newEntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Entry candidate = IntHashMap.this.getEntry(e.key);
            return candidate != null && candidate.equals(e);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return IntHashMap.this.count;
        }

        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return IntHashMap.this.newValueIterator();
        }

        public int size() {
            return IntHashMap.this.count;
        }

        public boolean contains(Object o) {
            return IntHashMap.this.containsValue(o);
        }

        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return IntHashMap.this.newKeyIterator();
        }

        public int size() {
            return IntHashMap.this.count;
        }

        public boolean contains(Object o) {
            if (o instanceof Number) {
                return IntHashMap.this.containsKey(((Number)o).intValue());
            }
            return false;
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return new Integer(this.nextEntry().key);
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator
    implements Iterator {
        Entry next;
        int index;
        Entry current;

        HashIterator() {
            Entry[] t = IntHashMap.this.table;
            int i = t.length;
            Entry n = null;
            if (IntHashMap.this.count != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        Entry nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry[] t = IntHashMap.this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = e;
            return this.current;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Entry {
        final int hash;
        final int key;
        Object value;
        Entry next;

        protected Entry(int hash2, int key2, Object value2, Entry next2) {
            this.hash = hash2;
            this.key = key2;
            this.value = value2;
            this.next = next2;
        }
    }
}

