/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhenNode
extends Node {
    protected final Node expressionNodes;
    protected final Node bodyNode;
    private final Node nextCase;
    public final CallSite eqq = MethodIndex.getFunctionalCallSite("===");

    public WhenNode(ISourcePosition position, Node expressionNodes, Node bodyNode, Node nextCase) {
        super(position);
        this.expressionNodes = expressionNodes;
        if (expressionNodes instanceof ArrayNode) {
            ((ArrayNode)expressionNodes).setLightweight(true);
        }
        assert (bodyNode != null) : "bodyNode is not null";
        this.bodyNode = bodyNode;
        this.nextCase = nextCase;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.WHENNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitWhenNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getNextCase() {
        return this.nextCase;
    }

    public Node getExpressionNodes() {
        return this.expressionNodes;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.expressionNodes, this.bodyNode, this.nextCase);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.bodyNode.interpret(runtime2, context, self, aBlock);
    }

    public IRubyObject when(IRubyObject value2, ThreadContext context, Ruby runtime2, IRubyObject self, Block aBlock) {
        RubyArray expressions = RuntimeHelpers.splatValue(this.expressionNodes.interpret(runtime2, context, self, aBlock));
        int k = expressions.getLength();
        for (int j = 0; j < k; ++j) {
            IRubyObject test2 = expressions.eltInternal(j);
            if ((value2 == null || !this.eqq.call(context, self, test2, value2).isTrue()) && (value2 != null || !test2.isTrue())) continue;
            return this.bodyNode.interpret(runtime2, context, self, aBlock);
        }
        return null;
    }
}

