/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.reflection.GenericMaster;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.api.mockito.internal.configuration.PowerMockitoInjectingAnnotationEngine;
import org.powermock.core.spi.listener.AnnotationEnablerListener;
import org.powermock.core.spi.support.AbstractPowerMockTestListenerBase;
import org.powermock.reflect.Whitebox;

public class AnnotationEnabler
extends AbstractPowerMockTestListenerBase
implements AnnotationEnablerListener {
    public void beforeTestMethod(Object testInstance, Method method, Object[] arguments) throws Exception {
        this.standardInject(testInstance);
        this.injectSpiesAndInjectToSetters(testInstance);
        this.injectCaptor(testInstance);
    }

    private void injectSpiesAndInjectToSetters(Object testInstance) {
        new PowerMockitoInjectingAnnotationEngine().process(testInstance.getClass(), testInstance);
    }

    private void injectCaptor(Object testInstance) throws Exception {
        Set fieldsAnnotatedWithCaptor = Whitebox.getFieldsAnnotatedWith((Object)testInstance, Captor.class, (Class[])new Class[0]);
        for (Field field : fieldsAnnotatedWithCaptor) {
            Object captor = this.processAnnotationOn(field.getAnnotation(Captor.class), field);
            field.set(testInstance, captor);
        }
    }

    private void standardInject(Object testInstance) throws IllegalAccessException {
        Set fields = Whitebox.getFieldsAnnotatedWith((Object)testInstance, (Class[])this.getMockAnnotations());
        for (Field field : fields) {
            if (field.get(testInstance) != null) continue;
            Class<?> type = field.getType();
            if (field.isAnnotationPresent(Mock.class)) {
                String name;
                Class[] extraInterfaces;
                Mock mockAnnotation = field.getAnnotation(Mock.class);
                MockSettings mockSettings = Mockito.withSettings();
                Answers answers = mockAnnotation.answer();
                if (answers != null) {
                    mockSettings.defaultAnswer(answers.get());
                }
                if ((extraInterfaces = mockAnnotation.extraInterfaces()) != null && extraInterfaces.length > 0) {
                    mockSettings.extraInterfaces(extraInterfaces);
                }
                if ((name = mockAnnotation.name()) != null && name.length() > 0) {
                    mockSettings.name(name);
                }
                field.set(testInstance, PowerMockito.mock(type, mockSettings));
                continue;
            }
            field.set(testInstance, PowerMockito.mock(type));
        }
    }

    public Class<? extends Annotation>[] getMockAnnotations() {
        return new Class[]{Mock.class, Mock.class};
    }

    private Object processAnnotationOn(Captor annotation, Field field) {
        Class<?> type = field.getType();
        if (!ArgumentCaptor.class.isAssignableFrom(type)) {
            throw new MockitoException("@Captor field must be of the type ArgumentCaptor.\nField: '" + field.getName() + "' has wrong type\nFor info how to use @Captor annotations see examples in javadoc for MockitoAnnotations class.");
        }
        Class cls = new GenericMaster().getGenericType(field);
        return ArgumentCaptor.forClass((Class)cls);
    }
}

