/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.mockmaker;

import org.mockito.Mockito;
import org.mockito.plugins.MockMaker;
import org.powermock.configuration.MockitoConfiguration;

class MockMakerLoader {
    MockMakerLoader() {
    }

    MockMaker load(MockitoConfiguration mockitoConfiguration) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        String mockMakerClassName = mockitoConfiguration.getMockMakerClass();
        try {
            return this.doLoad(loader, mockMakerClassName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load MockMaker implementation: " + mockMakerClassName, e);
        }
    }

    private MockMaker doLoad(ClassLoader loader, String mockMakerClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (mockMakerClassName == null) {
            return (MockMaker)Mockito.framework().getPlugins().getDefaultPlugin(MockMaker.class);
        }
        if ("mock-maker-inline".equals(mockMakerClassName)) {
            return Mockito.framework().getPlugins().getInlineMockMaker();
        }
        Class<?> mockMakerClass = loader.loadClass(mockMakerClassName);
        Object mockMaker = mockMakerClass.newInstance();
        return (MockMaker)MockMaker.class.cast(mockMaker);
    }
}

