/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.filter;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.boot.context.TypeExcludeFilter;
import org.springframework.boot.test.autoconfigure.filter.TypeExcludeFilters;
import org.springframework.boot.test.autoconfigure.filter.TypeExcludeFiltersContextCustomizer;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.util.ObjectUtils;

class TypeExcludeFiltersContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final Class<?>[] NO_FILTERS = new Class[0];

    TypeExcludeFiltersContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configurationAttributes) {
        Object[] filterClasses = MergedAnnotations.from(testClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).get(TypeExcludeFilters.class).getValue("value", Class[].class).orElse(NO_FILTERS);
        if (ObjectUtils.isEmpty((Object[])filterClasses)) {
            return null;
        }
        return this.createContextCustomizer(testClass, (Class<?>[])filterClasses);
    }

    private ContextCustomizer createContextCustomizer(Class<?> testClass, Class<?>[] filterClasses) {
        return new TypeExcludeFiltersContextCustomizer(testClass, new LinkedHashSet<Class<? extends TypeExcludeFilter>>(Arrays.asList(filterClasses)));
    }
}

