/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7FileMsgCorrector {
    private static final Logger ourLog = LoggerFactory.getLogger(HL7FileMsgCorrector.class);

    public static void main(String[] args) {
        String fileName = "./QueuedRoutStatOrders.dat";
        InputStream inputStream = HL7FileMsgCorrector.class.getClassLoader().getResourceAsStream(fileName);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedWriter writer = new BufferedWriter(new FileWriter("./correctedMessageFile.txt"));
            String lineRead = null;
            StringBuffer buf = new StringBuffer();
            while ((lineRead = reader.readLine()) != null) {
                buf.append(lineRead);
                buf.append("\r");
            }
            String fileString = buf.toString().trim();
            String newFileString = HL7FileMsgCorrector.addPreMshCarriageReturns(fileString);
            writer.write(newFileString);
            writer.close();
            ourLog.info("file conversion completed");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String addPreMshCarriageReturns(String theFileString) {
        theFileString = theFileString.replaceAll(".MSH\\|", "\rMSH|");
        theFileString = theFileString.replaceAll("MSH\\|", "\rMSH|");
        theFileString = theFileString.replaceAll("//", "");
        return theFileString;
    }
}

