/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionListener;
import ca.uhn.hl7v2.concurrent.DefaultExecutorService;
import ca.uhn.hl7v2.concurrent.Service;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.ReceivingApplicationExceptionHandler;
import ca.uhn.hl7v2.protocol.impl.AppRoutingDataImpl;
import ca.uhn.hl7v2.protocol.impl.AppWrapper;
import ca.uhn.hl7v2.protocol.impl.ApplicationRouterImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HL7Service
extends Service {
    private static final Logger log = LoggerFactory.getLogger(HL7Service.class);
    private final List<Connection> connections = new ArrayList<Connection>();
    private final Parser parser;
    private final LowerLayerProtocol llp;
    private final List<ConnectionListener> listeners = new ArrayList<ConnectionListener>();
    private final ConnectionCleaner cleaner;
    private final ApplicationRouterImpl applicationRouter;

    public HL7Service(HapiContext theHapiContext) {
        this(theHapiContext.getGenericParser(), theHapiContext.getLowerLayerProtocol(), theHapiContext.getExecutorService());
    }

    public HL7Service(Parser parser, LowerLayerProtocol llp) {
        this(parser, llp, DefaultExecutorService.getDefaultService());
    }

    public HL7Service(Parser parser, LowerLayerProtocol llp, ExecutorService executorService) {
        super("HL7 Server", executorService);
        this.parser = parser;
        this.llp = llp;
        this.applicationRouter = new ApplicationRouterImpl(parser);
        this.cleaner = new ConnectionCleaner(this);
        assert (!this.cleaner.isRunning());
    }

    @Override
    protected void afterStartup() {
        this.cleaner.start();
    }

    @Override
    protected void afterTermination() {
        super.afterTermination();
        this.cleaner.stopAndWait();
        for (Connection c : this.connections) {
            c.close();
        }
    }

    protected boolean keepRunning() {
        return this.isRunning();
    }

    LowerLayerProtocol getLlp() {
        return this.llp;
    }

    Parser getParser() {
        return this.parser;
    }

    public synchronized void newConnection(Connection c) {
        c.getResponder().setApplicationRouter(this.applicationRouter);
        c.activate();
        this.connections.add(c);
        this.notifyListeners(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getRemoteConnection(String IP) {
        Connection conn = null;
        while (conn == null) {
            HL7Service hL7Service = this;
            synchronized (hL7Service) {
                for (int c = 0; conn == null && c < this.connections.size(); ++c) {
                    Connection nextConn = this.connections.get(c);
                    if (!nextConn.getRemoteAddress().getHostAddress().equals(IP)) continue;
                    conn = nextConn;
                }
            }
            if (conn != null) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        return conn;
    }

    public synchronized List<Connection> getRemoteConnections() {
        return this.connections;
    }

    public synchronized void registerConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners(Connection c) {
        for (ConnectionListener cl : this.listeners) {
            if (c.isOpen()) {
                cl.connectionReceived(c);
                continue;
            }
            cl.connectionDiscarded(c);
        }
    }

    public synchronized void registerApplication(String messageType, String triggerEvent, Application handler) {
        AppWrapper handlerWrapper = new AppWrapper(handler);
        this.applicationRouter.bindApplication(new AppRoutingDataImpl(messageType, triggerEvent, "*", "*"), handlerWrapper);
    }

    public void registerApplication(String messageType, String triggerEvent, ReceivingApplication handler) {
        this.applicationRouter.bindApplication(new AppRoutingDataImpl(messageType, triggerEvent, "*", "*"), handler);
    }

    public synchronized void registerApplication(ApplicationRouter.AppRoutingData appRouting, ReceivingApplication application) {
        if (appRouting == null) {
            throw new NullPointerException("appRouting can not be null");
        }
        this.applicationRouter.bindApplication(appRouting, application);
    }

    public synchronized void registerApplication(ReceivingApplication application) {
        this.registerApplication(new AppRoutingDataImpl("*", "*", "*", "*"), application);
    }

    public synchronized void setExceptionHandler(ReceivingApplicationExceptionHandler exHandler) {
        this.applicationRouter.setExceptionHandler(exHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadApplicationsFromFile(File f) throws IOException, HL7Exception, ClassNotFoundException, InstantiationException, IllegalAccessException {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(f));
            while ((line = in.readLine()) != null) {
                String className;
                String event;
                String type;
                StringTokenizer tok = new StringTokenizer(line, "\t", false);
                if (!tok.hasMoreTokens()) continue;
                try {
                    type = tok.nextToken();
                    event = tok.nextToken();
                    className = tok.nextToken();
                }
                catch (NoSuchElementException ne) {
                    throw new HL7Exception("Can't register applications from file " + f.getName() + ". The line '" + line + "' is not of the form: message_type [tab] trigger_event [tab] application_class.");
                }
                try {
                    Class<?> appClass = Class.forName(className);
                    Application app = (Application)appClass.newInstance();
                    this.registerApplication(type, event, app);
                }
                catch (ClassCastException cce) {
                    throw new HL7Exception("The specified class, " + className + ", doesn't implement Application.");
                    return;
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class ConnectionCleaner
    extends Service {
        private final HL7Service service;

        public ConnectionCleaner(HL7Service service) {
            super("ConnectionCleaner", service.getExecutorService());
            this.service = service;
        }

        public void start() {
            log.info("Starting ConnectionCleaner service");
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle() {
            try {
                Thread.sleep(500L);
                HL7Service hL7Service = this.service;
                synchronized (hL7Service) {
                    Iterator<Connection> it = this.service.getRemoteConnections().iterator();
                    while (it.hasNext()) {
                        Connection conn = it.next();
                        if (conn.isOpen()) continue;
                        log.debug("Removing connection from {} from connection list", (Object)conn.getRemoteAddress().getHostAddress());
                        it.remove();
                        this.service.notifyListeners(conn);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

