/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.primitive;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormattedTextEncoder {
    private StringBuilder myBuffer;
    private int myInBold;
    private boolean myInCenter;

    private FormattedTextEncoder() {
    }

    private void addLt() {
        this.myBuffer.append("&lt;");
    }

    private void addGt() {
        this.myBuffer.append("&gt;");
    }

    private void addAmpersand() {
        this.myBuffer.append("&amp;");
    }

    private void addBreak() {
        this.myBuffer.append("<br>");
    }

    private void addEndNoBreak() {
        this.myBuffer.append("</nobr>");
    }

    private void addHighAscii(char nextChar) {
        this.myBuffer.append("&#");
        this.myBuffer.append((int)nextChar);
        this.myBuffer.append(";");
    }

    private void addSpace() {
        this.myBuffer.append("&nbsp;");
    }

    private void addStartCenter() {
        this.myBuffer.append("<center>");
    }

    private void addStartNoBreak() {
        this.myBuffer.append("<nobr>");
    }

    private void closeCenterIfNeeded() {
        if (this.myInCenter) {
            this.myBuffer.append("</center>");
        }
    }

    public String encode(String theInput) {
        if (theInput == null) {
            return null;
        }
        this.myBuffer = new StringBuilder(theInput.length() + 20);
        boolean myAtStartOfLine = true;
        this.myInCenter = false;
        boolean myWordWrap = true;
        int myCurrentLineOffset = 0;
        int myTemporaryIndent = 0;
        int myIndent = 0;
        boolean myNeedBreakBeforeNextText = false;
        boolean myInDiv = false;
        this.myInBold = 0;
        for (int i = 0; i < theInput.length(); ++i) {
            char nextChar = theInput.charAt(i);
            boolean handled = true;
            switch (nextChar) {
                case '\\': {
                    int j;
                    int theStart = i + 1;
                    int numericArgument = Integer.MIN_VALUE;
                    int offsetIncludingNumericArgument = 0;
                    String nextFourChars = theInput.substring(theStart, Math.min(theInput.length(), theStart + 4)).toLowerCase();
                    if (theInput.length() >= theStart + 5) {
                        char sep = theInput.charAt(i + 4);
                        if (theInput.charAt(i + 1) == '.' && (sep == ' ' || sep == '-' || sep == '+')) {
                            String nextThirtyChars = theInput.substring(theStart + 3, Math.min(theInput.length(), theStart + 30));
                            Matcher m = Pattern.compile("^([ +-]?[0-9]+)\\\\").matcher(nextThirtyChars);
                            if (m.find()) {
                                String group = m.group(1);
                                offsetIncludingNumericArgument = group.length() + 4;
                                group = group.replace('+', ' ').trim();
                                numericArgument = Integer.parseInt(group);
                            }
                        }
                    }
                    if (nextFourChars.equals(".br\\")) {
                        this.closeCenterIfNeeded();
                        if (myNeedBreakBeforeNextText) {
                            this.addBreak();
                        }
                        myNeedBreakBeforeNextText = true;
                        i += 4;
                        myAtStartOfLine = true;
                        this.myInCenter = false;
                        myCurrentLineOffset = 0;
                        break;
                    }
                    if (nextFourChars.startsWith("h\\")) {
                        this.startBold();
                        i += 2;
                        break;
                    }
                    if (nextFourChars.startsWith("n\\")) {
                        this.endBold();
                        i += 2;
                        break;
                    }
                    if (nextFourChars.startsWith(".in") && myAtStartOfLine && numericArgument != Integer.MIN_VALUE) {
                        myIndent = numericArgument;
                        myTemporaryIndent = 0;
                        i += offsetIncludingNumericArgument;
                        break;
                    }
                    if (nextFourChars.startsWith(".ti") && myAtStartOfLine && numericArgument != Integer.MIN_VALUE) {
                        myTemporaryIndent = numericArgument;
                        i += offsetIncludingNumericArgument;
                        break;
                    }
                    if (nextFourChars.equals(".ce\\")) {
                        this.closeCenterIfNeeded();
                        if (!myAtStartOfLine) {
                            this.addBreak();
                        }
                        this.addStartCenter();
                        i += 4;
                        myAtStartOfLine = false;
                        this.myInCenter = true;
                        break;
                    }
                    if (nextFourChars.equals(".fi\\")) {
                        if (!myWordWrap) {
                            this.addEndNoBreak();
                            myWordWrap = true;
                        }
                        i += 4;
                        break;
                    }
                    if (nextFourChars.equals(".nf\\")) {
                        if (myWordWrap) {
                            this.addStartNoBreak();
                            myWordWrap = false;
                        }
                        i += 4;
                        break;
                    }
                    if (nextFourChars.startsWith(".sp")) {
                        if (nextFourChars.equals(".sp\\")) {
                            numericArgument = 1;
                            i += 4;
                        } else if (numericArgument != -1) {
                            i += offsetIncludingNumericArgument;
                        }
                        if (numericArgument > 0) {
                            for (j = 0; j < numericArgument; ++j) {
                                this.addBreak();
                            }
                            for (j = 0; j < myCurrentLineOffset; ++j) {
                                this.addSpace();
                            }
                            break;
                        }
                        if (numericArgument != Integer.MIN_VALUE) break;
                        handled = false;
                        break;
                    }
                    if (nextFourChars.equals(".sk ") && numericArgument >= 0) {
                        for (j = 0; j < numericArgument; ++j) {
                            this.addSpace();
                        }
                        i += offsetIncludingNumericArgument;
                        break;
                    }
                    handled = false;
                    break;
                }
                default: {
                    handled = false;
                }
            }
            if (handled) continue;
            if (myAtStartOfLine) {
                int thisLineIndent = Math.max(0, myIndent + myTemporaryIndent);
                if (myNeedBreakBeforeNextText) {
                    if (myInDiv) {
                        this.myBuffer.append("</div>");
                    } else if (thisLineIndent == 0) {
                        this.addBreak();
                    }
                }
                if (thisLineIndent > 0) {
                    this.myBuffer.append("<div style=\"margin-left: ");
                    this.myBuffer.append(thisLineIndent);
                    this.myBuffer.append("em;\">");
                    myInDiv = true;
                }
            }
            switch (nextChar) {
                case '&': {
                    this.addAmpersand();
                    break;
                }
                case '<': {
                    this.addLt();
                    break;
                }
                case '>': {
                    this.addGt();
                    break;
                }
                default: {
                    if (nextChar >= '\u00a0') {
                        this.addHighAscii(nextChar);
                        break;
                    }
                    this.myBuffer.append(nextChar);
                }
            }
            myAtStartOfLine = false;
            myNeedBreakBeforeNextText = false;
            ++myCurrentLineOffset;
        }
        this.endBold();
        if (!myWordWrap) {
            this.addEndNoBreak();
        }
        this.closeCenterIfNeeded();
        if (myInDiv) {
            this.myBuffer.append("</div>");
        }
        return this.myBuffer.toString();
    }

    private void endBold() {
        for (int i = 0; i < this.myInBold; ++i) {
            this.myBuffer.append("</b>");
        }
        this.myInBold = 0;
    }

    private void startBold() {
        this.myBuffer.append("<b>");
        ++this.myInBold;
    }

    public static FormattedTextEncoder getInstanceHtml() {
        return new FormattedTextEncoder();
    }
}

