/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.validation.app.TestApplication;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiTestApplication
extends TestApplication {
    private List<TestApplication> tests = new ArrayList<TestApplication>(20);

    public boolean canProcess(Message in) {
        boolean can = false;
        for (int i = 0; !can && i < this.tests.size(); ++i) {
            can = this.tests.get(i).canProcess(in);
        }
        return can;
    }

    public HL7Exception[] test(Message in) throws HL7Exception {
        ArrayList<HL7Exception> problems = new ArrayList<HL7Exception>(40);
        for (int i = 0; i < this.tests.size(); ++i) {
            TestApplication app = this.tests.get(i);
            HL7Exception[] shortList = app.test(in);
            problems.addAll(Arrays.asList(shortList));
        }
        return problems.toArray(new HL7Exception[0]);
    }

    public void addTest(TestApplication test) {
        this.tests.add(test);
    }
}

